/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyObservableList;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import org.jabref.gui.StateManager;
import org.jabref.gui.groups.GroupViewMode;
import org.jabref.gui.groups.GroupsPreferences;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.MainTableFieldValueFormatter;
import org.jabref.gui.maintable.NameDisplayPreferences;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.logic.search.SearchQuery;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.search.matchers.MatcherSet;
import org.jabref.model.search.matchers.MatcherSets;
import org.jabref.preferences.PreferencesService;

public class MainTableDataModel {
    private final FilteredList<BibEntryTableViewModel> entriesFiltered;
    private final SortedList<BibEntryTableViewModel> entriesFilteredAndSorted;
    private final ObjectProperty<MainTableFieldValueFormatter> fieldValueFormatter = new SimpleObjectProperty();
    private final GroupsPreferences groupsPreferences;
    private final NameDisplayPreferences nameDisplayPreferences;
    private final BibDatabaseContext bibDatabaseContext;

    public MainTableDataModel(BibDatabaseContext context, PreferencesService preferencesService, StateManager stateManager) {
        this.groupsPreferences = preferencesService.getGroupsPreferences();
        this.nameDisplayPreferences = preferencesService.getNameDisplayPreferences();
        this.bibDatabaseContext = context;
        this.resetFieldFormatter();
        ObservableList<BibEntry> allEntries = BindingsHelper.forUI(context.getDatabase().getEntries());
        EasyObservableList entriesViewModel = EasyBind.mapBacked(allEntries, entry -> new BibEntryTableViewModel((BibEntry)entry, this.bibDatabaseContext, (ObservableValue<MainTableFieldValueFormatter>)this.fieldValueFormatter));
        this.entriesFiltered = new FilteredList((ObservableList)entriesViewModel);
        this.entriesFiltered.predicateProperty().bind((ObservableValue)EasyBind.combine(stateManager.activeGroupProperty(), stateManager.activeSearchQueryProperty(), this.groupsPreferences.groupViewModeProperty(), (groups, query, groupViewMode) -> entry -> this.isMatched((ObservableList<GroupTreeNode>)groups, (Optional<SearchQuery>)query, (BibEntryTableViewModel)entry)));
        SimpleIntegerProperty resultSize = new SimpleIntegerProperty();
        resultSize.bind((ObservableValue)Bindings.size(this.entriesFiltered));
        stateManager.setActiveSearchResultSize(context, (IntegerProperty)resultSize);
        this.entriesFilteredAndSorted = new SortedList(this.entriesFiltered);
    }

    private boolean isMatched(ObservableList<GroupTreeNode> groups, Optional<SearchQuery> query, BibEntryTableViewModel entry) {
        return this.isMatchedByGroup(groups, entry) && this.isMatchedBySearch(query, entry);
    }

    private boolean isMatchedBySearch(Optional<SearchQuery> query, BibEntryTableViewModel entry) {
        return query.map(matcher -> matcher.isMatch(entry.getEntry())).orElse(true);
    }

    private boolean isMatchedByGroup(ObservableList<GroupTreeNode> groups, BibEntryTableViewModel entry) {
        return this.createGroupMatcher((List<GroupTreeNode>)groups).map(matcher -> matcher.isMatch(entry.getEntry())).orElse(true);
    }

    private Optional<MatcherSet> createGroupMatcher(List<GroupTreeNode> selectedGroups) {
        if (selectedGroups == null || selectedGroups.isEmpty()) {
            return Optional.empty();
        }
        MatcherSet searchRules = MatcherSets.build(this.groupsPreferences.getGroupViewMode() == GroupViewMode.INTERSECTION ? MatcherSets.MatcherType.AND : MatcherSets.MatcherType.OR);
        for (GroupTreeNode node : selectedGroups) {
            searchRules.addRule(node.getSearchMatcher());
        }
        return Optional.of(searchRules);
    }

    public SortedList<BibEntryTableViewModel> getEntriesFilteredAndSorted() {
        return this.entriesFilteredAndSorted;
    }

    public void resetFieldFormatter() {
        this.fieldValueFormatter.setValue((Object)new MainTableFieldValueFormatter(this.nameDisplayPreferences, this.bibDatabaseContext));
    }
}

