/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable.columns;

import java.io.IOException;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.CellFactory;
import org.jabref.gui.maintable.MainTableColumnFactory;
import org.jabref.gui.maintable.MainTableColumnModel;
import org.jabref.gui.maintable.OpenUrlAction;
import org.jabref.gui.maintable.columns.MainTableColumn;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class LinkedIdentifierColumn
extends MainTableColumn<Map<Field, String>> {
    private final BibDatabaseContext database;
    private final CellFactory cellFactory;
    private final DialogService dialogService;
    private final PreferencesService preferences;

    public LinkedIdentifierColumn(MainTableColumnModel model, CellFactory cellFactory, BibDatabaseContext database, DialogService dialogService, PreferencesService preferences, StateManager stateManager) {
        super(model);
        this.database = database;
        this.cellFactory = cellFactory;
        this.dialogService = dialogService;
        this.preferences = preferences;
        Node headerGraphic = IconTheme.JabRefIcons.WWW.getGraphicNode();
        Tooltip.install((Node)headerGraphic, (Tooltip)new Tooltip(Localization.lang("Linked identifiers", new Object[0])));
        this.setGraphic(headerGraphic);
        this.getStyleClass().add((Object)"column-icon");
        MainTableColumnFactory.setExactWidth(this, 28.0);
        this.setResizable(false);
        this.setCellValueFactory(cellData -> ((BibEntryTableViewModel)cellData.getValue()).getLinkedIdentifiers());
        new ValueTableCellFactory().withGraphic(this::createIdentifierGraphic).withTooltip(this::createIdentifierTooltip).withMenu(this::createIdentifierMenu).withOnMouseClickedEvent((entry, linkedFiles) -> event -> {
            if (linkedFiles.size() == 1 && event.getButton() == MouseButton.PRIMARY) {
                new OpenUrlAction(dialogService, stateManager, preferences).execute();
            }
        }).install(this);
    }

    private Node createIdentifierGraphic(Map<Field, String> values) {
        if (values.size() > 1) {
            return IconTheme.JabRefIcons.LINK_VARIANT.getGraphicNode();
        }
        if (values.size() == 1) {
            return IconTheme.JabRefIcons.LINK.getGraphicNode();
        }
        return null;
    }

    private String createIdentifierTooltip(Map<Field, String> values) {
        StringBuilder identifiers = new StringBuilder();
        values.keySet().forEach(field -> identifiers.append(field.getDisplayName()).append(": ").append((String)values.get(field)).append("\n"));
        return identifiers.toString();
    }

    private ContextMenu createIdentifierMenu(BibEntryTableViewModel entry, Map<Field, String> values) {
        ContextMenu contextMenu = new ContextMenu();
        if (values.size() <= 1) {
            return null;
        }
        values.keySet().forEach(field -> {
            MenuItem menuItem = new MenuItem(field.getDisplayName() + ": " + ControlHelper.truncateString((String)values.get(field), -1, "...", ControlHelper.EllipsisPosition.CENTER), this.cellFactory.getTableIcon((Field)field));
            menuItem.setOnAction(event -> {
                try {
                    JabRefDesktop.openExternalViewer(this.database, this.preferences, (String)values.get(field), field, this.dialogService, entry.getEntry());
                }
                catch (IOException e) {
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Unable to open link.", new Object[0]), e);
                }
                event.consume();
            });
            contextMenu.getItems().add((Object)menuItem);
        });
        return contextMenu;
    }
}

