/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.mergeentries.FetchAndMergeEntry;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.PreferencesService;

public class MergeWithFetchedEntryAction
extends SimpleCommand {
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final PreferencesService preferencesService;
    private final UndoManager undoManager;
    private final TaskExecutor taskExecutor;

    public MergeWithFetchedEntryAction(DialogService dialogService, StateManager stateManager, TaskExecutor taskExecutor, PreferencesService preferencesService, UndoManager undoManager) {
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.taskExecutor = taskExecutor;
        this.preferencesService = preferencesService;
        this.undoManager = undoManager;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(1, stateManager).and((ObservableBooleanValue)ActionHelper.isAnyFieldSetForSelectedEntry(FetchAndMergeEntry.SUPPORTED_FIELDS, stateManager)));
    }

    public void execute() {
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            return;
        }
        if (this.stateManager.getSelectedEntries().size() != 1) {
            this.dialogService.showInformationDialogAndWait(Localization.lang("Merge entry with %0 information", new OrFields(StandardField.DOI, StandardField.ISBN, StandardField.EPRINT).getDisplayName()), Localization.lang("This operation requires exactly one item to be selected.", new Object[0]));
        }
        BibEntry originalEntry = (BibEntry)this.stateManager.getSelectedEntries().getFirst();
        new FetchAndMergeEntry(this.stateManager.getActiveDatabase().get(), this.taskExecutor, this.preferencesService, this.dialogService, this.undoManager).fetchAndMerge(originalEntry);
    }
}

