/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog.cell.sidebuttons;

import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import org.jabref.gui.actions.Action;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;

public class ToggleMergeUnmergeButton
extends Button {
    private final ObjectProperty<FieldState> fieldState = new SimpleObjectProperty((Object)FieldState.UNMERGED);
    private final BooleanProperty canMerge = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());
    private final ActionFactory actionFactory = new ActionFactory();
    private final Field field;

    public ToggleMergeUnmergeButton(Field field) {
        this.field = field;
        this.setMaxHeight(Double.MAX_VALUE);
        this.setFocusTraversable(false);
        this.configureMergeButton();
        this.disableProperty().bind((ObservableValue)this.canMergeProperty().not());
    }

    private void configureMergeButton() {
        ToggleMergeCommand mergeCommand = new ToggleMergeCommand();
        this.actionFactory.configureIconButton(mergeCommand.mergeAction, (Command)mergeCommand, (ButtonBase)this);
    }

    private void configureUnmergeButton() {
        ToggleMergeCommand unmergeCommand = new ToggleMergeCommand();
        this.actionFactory.configureIconButton(unmergeCommand.unmergeAction, (Command)unmergeCommand, (ButtonBase)this);
    }

    public ObjectProperty<FieldState> fieldStateProperty() {
        return this.fieldState;
    }

    private void setFieldState(FieldState fieldState) {
        this.fieldStateProperty().set((Object)fieldState);
    }

    public FieldState getFieldState() {
        return (FieldState)((Object)this.fieldState.get());
    }

    public BooleanProperty canMergeProperty() {
        return this.canMerge;
    }

    public boolean canMerge() {
        return this.canMerge.get();
    }

    public void setCanMerge(boolean value) {
        this.canMergeProperty().set(value);
    }

    public static enum FieldState {
        MERGED,
        UNMERGED;

    }

    private class ToggleMergeCommand
    extends SimpleCommand {
        private final Action mergeAction = new Action(){

            @Override
            public Optional<JabRefIcon> getIcon() {
                return Optional.of(IconTheme.JabRefIcons.MERGE_GROUPS);
            }

            @Override
            public String getText() {
                return Localization.lang("Merge %0", ToggleMergeUnmergeButton.this.field.getDisplayName());
            }
        };
        private final Action unmergeAction = new Action(){

            @Override
            public Optional<JabRefIcon> getIcon() {
                return Optional.of(IconTheme.JabRefIcons.UNDO);
            }

            @Override
            public String getText() {
                return Localization.lang("Unmerge %0", ToggleMergeUnmergeButton.this.field.getDisplayName());
            }
        };

        private ToggleMergeCommand() {
        }

        public void execute() {
            if (ToggleMergeUnmergeButton.this.fieldStateProperty().get() == FieldState.MERGED) {
                ToggleMergeUnmergeButton.this.setFieldState(FieldState.UNMERGED);
                ToggleMergeUnmergeButton.this.configureMergeButton();
            } else {
                ToggleMergeUnmergeButton.this.setFieldState(FieldState.MERGED);
                ToggleMergeUnmergeButton.this.configureUnmergeButton();
            }
        }
    }
}

