/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import com.sun.star.beans.IllegalTypeException;
import com.sun.star.beans.NotRemoveableException;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jabref.gui.DialogService;
import org.jabref.gui.openoffice.OOBibBaseConnect;
import org.jabref.gui.openoffice.OOError;
import org.jabref.logic.JabRefException;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.openoffice.NoDocumentFoundException;
import org.jabref.logic.openoffice.action.EditInsert;
import org.jabref.logic.openoffice.action.EditMerge;
import org.jabref.logic.openoffice.action.EditSeparate;
import org.jabref.logic.openoffice.action.ExportCited;
import org.jabref.logic.openoffice.action.ManageCitations;
import org.jabref.logic.openoffice.action.Update;
import org.jabref.logic.openoffice.frontend.OOFrontend;
import org.jabref.logic.openoffice.frontend.RangeForOverlapCheck;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.openoffice.CitationEntry;
import org.jabref.model.openoffice.rangesort.FunctionalTextViewCursor;
import org.jabref.model.openoffice.style.CitationGroupId;
import org.jabref.model.openoffice.style.CitationType;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.NoDocumentException;
import org.jabref.model.openoffice.uno.UnoCrossRef;
import org.jabref.model.openoffice.uno.UnoCursor;
import org.jabref.model.openoffice.uno.UnoRedlines;
import org.jabref.model.openoffice.uno.UnoStyle;
import org.jabref.model.openoffice.uno.UnoUndo;
import org.jabref.model.openoffice.util.OOResult;
import org.jabref.model.openoffice.util.OOVoidResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OOBibBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(OOBibBase.class);
    private final DialogService dialogService;
    private final boolean refreshBibliographyDuringSyncWhenCiting;
    private final boolean alwaysAddCitedOnPages;
    private final OOBibBaseConnect connection;

    public OOBibBase(Path loPath, DialogService dialogService) throws BootstrapException, CreationException {
        this.dialogService = dialogService;
        this.connection = new OOBibBaseConnect(loPath, dialogService);
        this.refreshBibliographyDuringSyncWhenCiting = false;
        this.alwaysAddCitedOnPages = false;
    }

    public void guiActionSelectDocument(boolean autoSelectForSingle) {
        String errorTitle = Localization.lang("Problem connecting", new Object[0]);
        try {
            this.connection.selectDocument(autoSelectForSingle);
        }
        catch (NoDocumentFoundException ex) {
            OOError.from(ex).showErrorDialog(this.dialogService);
        }
        catch (DisposedException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        catch (NoSuchElementException | WrappedTargetException | IndexOutOfBoundsException ex) {
            LOGGER.warn("Problem connecting", ex);
            OOError.fromMisc((Exception)ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        if (this.isConnectedToDocument()) {
            this.dialogService.notify(Localization.lang("Connected to document", new Object[0]) + ": " + this.getCurrentDocumentTitle().orElse(""));
        }
    }

    public boolean isConnectedToDocument() {
        return this.connection.isConnectedToDocument();
    }

    public boolean isDocumentConnectionMissing() {
        return this.connection.isDocumentConnectionMissing();
    }

    public OOResult<XTextDocument, OOError> getXTextDocument() {
        return this.connection.getXTextDocument();
    }

    public Optional<String> getCurrentDocumentTitle() {
        return this.connection.getCurrentDocumentTitle();
    }

    void showDialog(OOError err) {
        err.showErrorDialog(this.dialogService);
    }

    void showDialog(String errorTitle, OOError err) {
        err.setTitle(errorTitle).showErrorDialog(this.dialogService);
    }

    OOVoidResult<OOError> collectResults(String errorTitle, List<OOVoidResult<OOError>> results) {
        String msg = results.stream().filter(OOVoidResult::isError).map(e -> ((OOError)e.getError()).getLocalizedMessage()).collect(Collectors.joining("\n\n"));
        if (msg.isEmpty()) {
            return OOVoidResult.ok();
        }
        return OOVoidResult.error(new OOError(errorTitle, msg));
    }

    boolean testDialog(OOVoidResult<OOError> res) {
        return res.ifError(ex -> ex.showErrorDialog(this.dialogService)).isError();
    }

    boolean testDialog(String errorTitle, OOVoidResult<OOError> res) {
        return res.ifError(e -> this.showDialog(e.setTitle(errorTitle))).isError();
    }

    boolean testDialog(String errorTitle, List<OOVoidResult<OOError>> results) {
        return this.testDialog(errorTitle, this.collectResults(errorTitle, results));
    }

    @SafeVarargs
    final boolean testDialog(String errorTitle, OOVoidResult<OOError> ... results) {
        List<OOVoidResult<OOError>> resultList = Arrays.asList(results);
        return this.testDialog(this.collectResults(errorTitle, resultList));
    }

    OOResult<XTextCursor, OOError> getUserCursorForTextInsertion(XTextDocument doc, String errorTitle) {
        XTextCursor cursor = UnoCursor.getViewCursor(doc).orElse(null);
        Objects.requireNonNull(cursor);
        try {
            cursor.getStart();
        }
        catch (com.sun.star.uno.RuntimeException ex) {
            String msg = Localization.lang("Please move the cursor to the location for the new citation.", new Object[0]) + "\n" + Localization.lang("I cannot insert to the cursor's current location.", new Object[0]);
            return OOResult.error(new OOError(errorTitle, msg, ex));
        }
        return OOResult.ok(cursor);
    }

    OOResult<FunctionalTextViewCursor, OOError> getFunctionalTextViewCursor(XTextDocument doc, String errorTitle) {
        String messageOnFailureToObtain = Localization.lang("Please move the cursor into the document text.", new Object[0]) + "\n" + Localization.lang("To get the visual positions of your citations I need to move the cursor around, but could not get it.", new Object[0]);
        OOResult<FunctionalTextViewCursor, String> result = FunctionalTextViewCursor.get(doc);
        if (result.isError()) {
            LOGGER.warn(result.getError());
        }
        return result.mapError(detail -> new OOError(errorTitle, messageOnFailureToObtain));
    }

    private static OOVoidResult<OOError> checkRangeOverlaps(XTextDocument doc, OOFrontend frontend) {
        String errorTitle = "Overlapping ranges";
        boolean requireSeparation = false;
        int maxReportedOverlaps = 10;
        try {
            return frontend.checkRangeOverlaps(doc, new ArrayList<RangeForOverlapCheck<CitationGroupId>>(), requireSeparation, maxReportedOverlaps).mapError(OOError::from);
        }
        catch (NoDocumentException ex) {
            return OOVoidResult.error(OOError.from(ex).setTitle("Overlapping ranges"));
        }
        catch (WrappedTargetException ex) {
            return OOVoidResult.error(OOError.fromMisc((Exception)((Object)ex)).setTitle("Overlapping ranges"));
        }
    }

    private static OOVoidResult<OOError> checkRangeOverlapsWithCursor(XTextDocument doc, OOFrontend frontend) {
        OOVoidResult<JabRefException> res;
        String errorTitle = "Ranges overlapping with cursor";
        List<RangeForOverlapCheck<CitationGroupId>> userRanges = frontend.viewCursorRanges(doc);
        boolean requireSeparation = false;
        try {
            res = frontend.checkRangeOverlapsWithCursor(doc, userRanges, requireSeparation);
        }
        catch (NoDocumentException ex) {
            return OOVoidResult.error(OOError.from(ex).setTitle("Ranges overlapping with cursor"));
        }
        catch (WrappedTargetException ex) {
            return OOVoidResult.error(OOError.fromMisc((Exception)((Object)ex)).setTitle("Ranges overlapping with cursor"));
        }
        if (res.isError()) {
            String xtitle = Localization.lang("The cursor is in a protected area.", new Object[0]);
            return OOVoidResult.error(new OOError(xtitle, xtitle + "\n" + res.getError().getLocalizedMessage() + "\n"));
        }
        return res.mapError(OOError::from);
    }

    private static OOVoidResult<OOError> checkIfOpenOfficeIsRecordingChanges(XTextDocument doc) {
        String errorTitle = Localization.lang("Recording and/or Recorded changes", new Object[0]);
        try {
            boolean recordingChanges = UnoRedlines.getRecordChanges(doc);
            int nRedlines = UnoRedlines.countRedlines(doc);
            if (recordingChanges || nRedlines > 0) {
                Object msg = "";
                if (recordingChanges) {
                    msg = (String)msg + Localization.lang("Cannot work with [Edit]/[Track Changes]/[Record] turned on.", new Object[0]);
                }
                if (nRedlines > 0) {
                    if (recordingChanges) {
                        msg = (String)msg + "\n";
                    }
                    msg = (String)msg + Localization.lang("Changes by JabRef could result in unexpected interactions with recorded changes.", new Object[0]);
                    msg = (String)msg + "\n";
                    msg = (String)msg + Localization.lang("Use [Edit]/[Track Changes]/[Manage] to resolve them first.", new Object[0]);
                }
                return OOVoidResult.error(new OOError(errorTitle, (String)msg));
            }
        }
        catch (WrappedTargetException ex) {
            String msg = Localization.lang("Error while checking if Writer is recording changes or has recorded changes.", new Object[0]);
            return OOVoidResult.error(new OOError(errorTitle, msg, ex));
        }
        return OOVoidResult.ok();
    }

    OOVoidResult<OOError> styleIsRequired(OOBibStyle style) {
        if (style == null) {
            return OOVoidResult.error(OOError.noValidStyleSelected());
        }
        return OOVoidResult.ok();
    }

    OOResult<OOFrontend, OOError> getFrontend(XTextDocument doc) {
        String errorTitle = "Unable to get frontend";
        try {
            return OOResult.ok(new OOFrontend(doc));
        }
        catch (NoDocumentException ex) {
            return OOResult.error(OOError.from(ex).setTitle("Unable to get frontend"));
        }
        catch (WrappedTargetException | RuntimeException ex) {
            return OOResult.error(OOError.fromMisc((Exception)ex).setTitle("Unable to get frontend"));
        }
    }

    OOVoidResult<OOError> databaseIsRequired(List<BibDatabase> databases, Supplier<OOError> fun) {
        if (databases == null || databases.isEmpty()) {
            return OOVoidResult.error(fun.get());
        }
        return OOVoidResult.ok();
    }

    OOVoidResult<OOError> selectedBibEntryIsRequired(List<BibEntry> entries, Supplier<OOError> fun) {
        if (entries == null || entries.isEmpty()) {
            return OOVoidResult.error(fun.get());
        }
        return OOVoidResult.ok();
    }

    private OOVoidResult<OOError> checkStyleExistsInTheDocument(String familyName, String styleName, XTextDocument doc, String labelInJstyleFile, String pathToStyleFile) throws WrappedTargetException {
        Optional<String> internalName = UnoStyle.getInternalNameOfStyle(doc, familyName, styleName);
        if (internalName.isEmpty()) {
            String msg = (switch (familyName) {
                case "ParagraphStyles" -> Localization.lang("The %0 paragraph style '%1' is missing from the document", labelInJstyleFile, styleName);
                case "CharacterStyles" -> Localization.lang("The %0 character style '%1' is missing from the document", labelInJstyleFile, styleName);
                default -> throw new java.lang.IllegalArgumentException("Expected CharacterStyles or ParagraphStyles for familyName");
            }) + "\n" + Localization.lang("Please create it in the document or change in the file:", new Object[0]) + "\n" + pathToStyleFile;
            return OOVoidResult.error(new OOError("StyleIsNotKnown", msg));
        }
        if (!internalName.get().equals(styleName)) {
            String msg = (switch (familyName) {
                case "ParagraphStyles" -> Localization.lang("The %0 paragraph style '%1' is a display name for '%2'.", labelInJstyleFile, styleName, internalName.get());
                case "CharacterStyles" -> Localization.lang("The %0 character style '%1' is a display name for '%2'.", labelInJstyleFile, styleName, internalName.get());
                default -> throw new java.lang.IllegalArgumentException("Expected CharacterStyles or ParagraphStyles for familyName");
            }) + "\n" + Localization.lang("Please use the latter in the style file below to avoid localization problems.", new Object[0]) + "\n" + pathToStyleFile;
            return OOVoidResult.error(new OOError("StyleNameIsNotInternal", msg));
        }
        return OOVoidResult.ok();
    }

    public OOVoidResult<OOError> checkStylesExistInTheDocument(OOBibStyle style, XTextDocument doc) {
        String pathToStyleFile = style.getPath();
        ArrayList<OOVoidResult<OOError>> results = new ArrayList<OOVoidResult<OOError>>();
        try {
            results.add(this.checkStyleExistsInTheDocument("ParagraphStyles", style.getReferenceHeaderParagraphFormat(), doc, "ReferenceHeaderParagraphFormat", pathToStyleFile));
            results.add(this.checkStyleExistsInTheDocument("ParagraphStyles", style.getReferenceParagraphFormat(), doc, "ReferenceParagraphFormat", pathToStyleFile));
            if (style.isFormatCitations()) {
                results.add(this.checkStyleExistsInTheDocument("CharacterStyles", style.getCitationCharacterFormat(), doc, "CitationCharacterFormat", pathToStyleFile));
            }
        }
        catch (WrappedTargetException ex) {
            results.add(OOVoidResult.error(new OOError("Other error in checkStyleExistsInTheDocument", ex.getMessage(), ex)));
        }
        return this.collectResults("checkStyleExistsInTheDocument failed", results);
    }

    public Optional<List<CitationEntry>> guiActionGetCitationEntries() {
        OOResult<XTextDocument, OOError> odoc;
        Optional<List<CitationEntry>> FAIL = Optional.empty();
        String errorTitle = Localization.lang("Problem collecting citations", new Object[0]);
        if (this.testDialog(errorTitle, (odoc = this.getXTextDocument()).asVoidResult())) {
            return FAIL;
        }
        XTextDocument doc = odoc.get();
        if (this.testDialog(errorTitle, OOBibBase.checkIfOpenOfficeIsRecordingChanges(doc))) {
            LOGGER.warn(errorTitle);
            return FAIL;
        }
        try {
            return Optional.of(ManageCitations.getCitationEntries(doc));
        }
        catch (NoDocumentException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
            return FAIL;
        }
        catch (DisposedException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
            return FAIL;
        }
        catch (WrappedTargetException ex) {
            LOGGER.warn(errorTitle, (Throwable)ex);
            OOError.fromMisc((Exception)((Object)ex)).setTitle(errorTitle).showErrorDialog(this.dialogService);
            return FAIL;
        }
    }

    public void guiActionApplyCitationEntries(List<CitationEntry> citationEntries) {
        OOResult<XTextDocument, OOError> odoc;
        String errorTitle = Localization.lang("Problem modifying citation", new Object[0]);
        if (this.testDialog(errorTitle, (odoc = this.getXTextDocument()).asVoidResult())) {
            return;
        }
        XTextDocument doc = odoc.get();
        try {
            ManageCitations.applyCitationEntries(doc, citationEntries);
        }
        catch (NoDocumentException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        catch (DisposedException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        catch (IllegalTypeException | PropertyVetoException | IllegalArgumentException | WrappedTargetException ex) {
            LOGGER.warn(errorTitle, ex);
            OOError.fromMisc((Exception)ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void guiActionInsertEntry(List<BibEntry> entries, BibDatabase database, OOBibStyle style, CitationType citationType, String pageInfo, Optional<Update.SyncOptions> syncOptions) {
        String errorTitle = "Could not insert citation";
        OOResult<XTextDocument, OOError> odoc = this.getXTextDocument();
        if (this.testDialog("Could not insert citation", odoc.asVoidResult(), this.styleIsRequired(style), this.selectedBibEntryIsRequired(entries, OOError::noEntriesSelectedForCitation))) {
            return;
        }
        XTextDocument doc = odoc.get();
        OOResult<OOFrontend, OOError> frontend = this.getFrontend(doc);
        if (this.testDialog("Could not insert citation", frontend.asVoidResult())) {
            return;
        }
        OOResult<XTextCursor, OOError> cursor = this.getUserCursorForTextInsertion(doc, "Could not insert citation");
        if (this.testDialog("Could not insert citation", cursor.asVoidResult())) {
            return;
        }
        if (this.testDialog("Could not insert citation", OOBibBase.checkRangeOverlapsWithCursor(doc, frontend.get()))) {
            return;
        }
        if (this.testDialog("Could not insert citation", this.checkStylesExistInTheDocument(style, doc), OOBibBase.checkIfOpenOfficeIsRecordingChanges(doc))) {
            return;
        }
        OOResult<FunctionalTextViewCursor, OOError> fcursor = null;
        if (syncOptions.isPresent() && this.testDialog("Could not insert citation", (fcursor = this.getFunctionalTextViewCursor(doc, "Could not insert citation")).asVoidResult())) {
            return;
        }
        syncOptions.map(e -> e.setUpdateBibliography(this.refreshBibliographyDuringSyncWhenCiting)).map(e -> e.setAlwaysAddCitedOnPages(this.alwaysAddCitedOnPages));
        if (syncOptions.isPresent() && this.testDialog(this.databaseIsRequired(syncOptions.get().databases, OOError::noDataBaseIsOpenForSyncingAfterCitation))) {
            return;
        }
        try {
            UnoUndo.enterUndoContext(doc, "Insert citation");
            EditInsert.insertCitationGroup(doc, frontend.get(), cursor.get(), entries, database, style, citationType, pageInfo);
            if (syncOptions.isPresent()) {
                Update.resyncDocument(doc, style, fcursor.get(), syncOptions.get());
            }
        }
        catch (NoDocumentException ex) {
            OOError.from(ex).setTitle("Could not insert citation").showErrorDialog(this.dialogService);
        }
        catch (DisposedException ex) {
            OOError.from(ex).setTitle("Could not insert citation").showErrorDialog(this.dialogService);
        }
        catch (IllegalTypeException | NotRemoveableException | PropertyVetoException | WrappedTargetException | CreationException ex) {
            LOGGER.warn("Could not insert entry", ex);
            OOError.fromMisc((Exception)ex).setTitle("Could not insert citation").showErrorDialog(this.dialogService);
        }
        finally {
            UnoUndo.leaveUndoContext(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void guiActionMergeCitationGroups(List<BibDatabase> databases, OOBibStyle style) {
        String errorTitle = Localization.lang("Problem combining cite markers", new Object[0]);
        OOResult<XTextDocument, OOError> odoc = this.getXTextDocument();
        if (this.testDialog(errorTitle, odoc.asVoidResult(), this.styleIsRequired(style), this.databaseIsRequired(databases, OOError::noDataBaseIsOpen))) {
            return;
        }
        XTextDocument doc = odoc.get();
        OOResult<FunctionalTextViewCursor, OOError> fcursor = this.getFunctionalTextViewCursor(doc, errorTitle);
        if (this.testDialog(errorTitle, fcursor.asVoidResult(), this.checkStylesExistInTheDocument(style, doc), OOBibBase.checkIfOpenOfficeIsRecordingChanges(doc))) {
            return;
        }
        try {
            UnoUndo.enterUndoContext(doc, "Merge citations");
            OOFrontend frontend = new OOFrontend(doc);
            boolean madeModifications = EditMerge.mergeCitationGroups(doc, frontend, style);
            if (madeModifications) {
                UnoCrossRef.refresh(doc);
                Update.SyncOptions syncOptions = new Update.SyncOptions(databases);
                Update.resyncDocument(doc, style, fcursor.get(), syncOptions);
            }
        }
        catch (NoDocumentException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        catch (DisposedException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        catch (IllegalTypeException | NotRemoveableException | PropertyVetoException | IllegalArgumentException | WrappedTargetException | CreationException ex) {
            LOGGER.warn("Problem combining cite markers", ex);
            OOError.fromMisc((Exception)ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        finally {
            UnoUndo.leaveUndoContext(doc);
            fcursor.get().restore(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void guiActionSeparateCitations(List<BibDatabase> databases, OOBibStyle style) {
        String errorTitle = Localization.lang("Problem during separating cite markers", new Object[0]);
        OOResult<XTextDocument, OOError> odoc = this.getXTextDocument();
        if (this.testDialog(errorTitle, odoc.asVoidResult(), this.styleIsRequired(style), this.databaseIsRequired(databases, OOError::noDataBaseIsOpen))) {
            return;
        }
        XTextDocument doc = odoc.get();
        OOResult<FunctionalTextViewCursor, OOError> fcursor = this.getFunctionalTextViewCursor(doc, errorTitle);
        if (this.testDialog(errorTitle, fcursor.asVoidResult(), this.checkStylesExistInTheDocument(style, doc), OOBibBase.checkIfOpenOfficeIsRecordingChanges(doc))) {
            return;
        }
        try {
            UnoUndo.enterUndoContext(doc, "Separate citations");
            OOFrontend frontend = new OOFrontend(doc);
            boolean madeModifications = EditSeparate.separateCitations(doc, frontend, databases, style);
            if (madeModifications) {
                UnoCrossRef.refresh(doc);
                Update.SyncOptions syncOptions = new Update.SyncOptions(databases);
                Update.resyncDocument(doc, style, fcursor.get(), syncOptions);
            }
        }
        catch (NoDocumentException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        catch (DisposedException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        catch (IllegalTypeException | NotRemoveableException | PropertyVetoException | IllegalArgumentException | WrappedTargetException | CreationException ex) {
            LOGGER.warn("Problem during separating cite markers", ex);
            OOError.fromMisc((Exception)ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        finally {
            UnoUndo.leaveUndoContext(doc);
            fcursor.get().restore(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<BibDatabase> exportCitedHelper(List<BibDatabase> databases, boolean returnPartialResult) {
        Optional<BibDatabase> FAIL = Optional.empty();
        String errorTitle = Localization.lang("Unable to generate new library", new Object[0]);
        OOResult<XTextDocument, OOError> odoc = this.getXTextDocument();
        if (this.testDialog(errorTitle, odoc.asVoidResult(), this.databaseIsRequired(databases, OOError::noDataBaseIsOpenForExport))) {
            return FAIL;
        }
        XTextDocument doc = odoc.get();
        try {
            ExportCited.GenerateDatabaseResult result;
            try {
                UnoUndo.enterUndoContext(doc, "Changes during \"Export cited\"");
                result = ExportCited.generateDatabase(doc, databases);
            }
            finally {
                UnoUndo.leaveUndoContext(doc);
            }
            if (!result.newDatabase.hasEntries()) {
                this.dialogService.showErrorDialogAndWait(Localization.lang("Unable to generate new library", new Object[0]), Localization.lang("Your OpenOffice/LibreOffice document references no citation keys which could also be found in your current library.", new Object[0]));
                return FAIL;
            }
            List<String> unresolvedKeys = result.unresolvedKeys;
            if (!unresolvedKeys.isEmpty()) {
                this.dialogService.showErrorDialogAndWait(Localization.lang("Unable to generate new library", new Object[0]), Localization.lang("Your OpenOffice/LibreOffice document references at least %0 citation keys which could not be found in your current library. Some of these are %1.", String.valueOf(unresolvedKeys.size()), String.join((CharSequence)", ", unresolvedKeys)));
                if (returnPartialResult) {
                    return Optional.of(result.newDatabase);
                }
                return FAIL;
            }
            return Optional.of(result.newDatabase);
        }
        catch (NoDocumentException ex) {
            OOError.from(ex).showErrorDialog(this.dialogService);
        }
        catch (DisposedException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        catch (IllegalArgumentException | WrappedTargetException ex) {
            LOGGER.warn("Problem generating new database.", ex);
            OOError.fromMisc((Exception)ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        return FAIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void guiActionUpdateDocument(List<BibDatabase> databases, OOBibStyle style) {
        String errorTitle = Localization.lang("Unable to synchronize bibliography", new Object[0]);
        try {
            List<String> unresolvedKeys;
            OOResult<XTextDocument, OOError> odoc = this.getXTextDocument();
            if (this.testDialog(errorTitle, odoc.asVoidResult(), this.styleIsRequired(style))) {
                return;
            }
            XTextDocument doc = odoc.get();
            OOResult<FunctionalTextViewCursor, OOError> fcursor = this.getFunctionalTextViewCursor(doc, errorTitle);
            if (this.testDialog(errorTitle, fcursor.asVoidResult(), this.checkStylesExistInTheDocument(style, doc), OOBibBase.checkIfOpenOfficeIsRecordingChanges(doc))) {
                return;
            }
            OOFrontend frontend = new OOFrontend(doc);
            if (this.testDialog(errorTitle, OOBibBase.checkRangeOverlaps(doc, frontend))) {
                return;
            }
            try {
                UnoUndo.enterUndoContext(doc, "Refresh bibliography");
                Update.SyncOptions syncOptions = new Update.SyncOptions(databases);
                syncOptions.setUpdateBibliography(true).setAlwaysAddCitedOnPages(this.alwaysAddCitedOnPages);
                unresolvedKeys = Update.synchronizeDocument(doc, frontend, style, fcursor.get(), syncOptions);
            }
            finally {
                UnoUndo.leaveUndoContext(doc);
                fcursor.get().restore(doc);
            }
            if (!unresolvedKeys.isEmpty()) {
                String msg = Localization.lang("Your OpenOffice/LibreOffice document references the citation key '%0', which could not be found in your current library.", unresolvedKeys.getFirst());
                this.dialogService.showErrorDialogAndWait(errorTitle, msg);
            }
        }
        catch (NoDocumentException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        catch (DisposedException ex) {
            OOError.from(ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
        catch (IllegalArgumentException | WrappedTargetException | CreationException ex) {
            LOGGER.warn("Could not update bibliography", ex);
            OOError.fromMisc((Exception)ex).setTitle(errorTitle).showErrorDialog(this.dialogService);
        }
    }
}

