/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Labeled;
import org.jabref.gui.preferences.PreferencesTab;

class PreferencesSearchHandler {
    private static PseudoClass labelHighlight = PseudoClass.getPseudoClass((String)"search-highlight");
    private final List<PreferencesTab> preferenceTabs;
    private final ListProperty<PreferencesTab> filteredPreferenceTabs;
    private final ArrayListMultimap<PreferencesTab, Labeled> preferenceTabsLabelNames;
    private final ArrayList<Labeled> highlightedLabels = new ArrayList();

    PreferencesSearchHandler(List<PreferencesTab> preferenceTabs) {
        this.preferenceTabs = preferenceTabs;
        this.preferenceTabsLabelNames = this.getPrefsTabLabelMap();
        this.filteredPreferenceTabs = new SimpleListProperty(FXCollections.observableArrayList(preferenceTabs));
    }

    public void filterTabs(String text) {
        this.clearHighlights();
        if (text.isEmpty()) {
            this.clearSearch();
            return;
        }
        this.filteredPreferenceTabs.clear();
        for (PreferencesTab tab : this.preferenceTabsLabelNames.keySet()) {
            boolean tabContainsLabel = false;
            for (Labeled labeled : this.preferenceTabsLabelNames.get((Object)tab)) {
                if (!this.labelContainsText(labeled, text)) continue;
                tabContainsLabel = true;
                this.highlightLabel(labeled);
            }
            boolean tabNameIsMatchedByQuery = tab.getTabName().toLowerCase(Locale.ROOT).contains(text);
            if (!tabContainsLabel && !tabNameIsMatchedByQuery) continue;
            this.filteredPreferenceTabs.add((Object)tab);
        }
    }

    private boolean labelContainsText(Labeled labeled, String text) {
        return labeled.getText().toLowerCase(Locale.ROOT).contains(text);
    }

    private void highlightLabel(Labeled labeled) {
        labeled.pseudoClassStateChanged(labelHighlight, true);
        this.highlightedLabels.add(labeled);
    }

    private void clearHighlights() {
        this.highlightedLabels.forEach(labeled -> labeled.pseudoClassStateChanged(labelHighlight, false));
    }

    private void clearSearch() {
        this.filteredPreferenceTabs.setAll(this.preferenceTabs);
    }

    private ArrayListMultimap<PreferencesTab, Labeled> getPrefsTabLabelMap() {
        ArrayListMultimap prefsTabLabelMap = ArrayListMultimap.create();
        for (PreferencesTab preferencesTab : this.preferenceTabs) {
            Node builder = preferencesTab.getBuilder();
            if (!(builder instanceof Parent)) continue;
            Parent parentBuilder = (Parent)builder;
            PreferencesSearchHandler.scanLabeledControls(parentBuilder, (ArrayListMultimap<PreferencesTab, Labeled>)prefsTabLabelMap, preferencesTab);
        }
        return prefsTabLabelMap;
    }

    protected ListProperty<PreferencesTab> filteredPreferenceTabsProperty() {
        return this.filteredPreferenceTabs;
    }

    private static void scanLabeledControls(Parent parent, ArrayListMultimap<PreferencesTab, Labeled> prefsTabLabelMap, PreferencesTab preferencesTab) {
        for (Node child : parent.getChildrenUnmodifiable()) {
            if (child instanceof Labeled) {
                Labeled labeled = (Labeled)child;
                if (labeled.getText().isEmpty()) continue;
                prefsTabLabelMap.put((Object)preferencesTab, (Object)labeled);
                continue;
            }
            if (!(child instanceof Parent)) continue;
            Parent parentChild = (Parent)child;
            PreferencesSearchHandler.scanLabeledControls(parentChild, prefsTabLabelMap, preferencesTab);
        }
    }
}

