/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.citationkeypattern;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import org.jabref.gui.commonfxcontrols.CitationKeyPatternsPanelItemModel;
import org.jabref.gui.commonfxcontrols.CitationKeyPatternsPanelViewModel;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.logic.citationkeypattern.CitationKeyPatternPreferences;
import org.jabref.logic.citationkeypattern.GlobalCitationKeyPatterns;

public class CitationKeyPatternTabViewModel
implements PreferenceTabViewModel {
    private final BooleanProperty overwriteAllowProperty = new SimpleBooleanProperty();
    private final BooleanProperty overwriteWarningProperty = new SimpleBooleanProperty();
    private final BooleanProperty generateOnSaveProperty = new SimpleBooleanProperty();
    private final BooleanProperty letterStartAProperty = new SimpleBooleanProperty();
    private final BooleanProperty letterStartBProperty = new SimpleBooleanProperty();
    private final BooleanProperty letterAlwaysAddProperty = new SimpleBooleanProperty();
    private final StringProperty keyPatternRegexProperty = new SimpleStringProperty();
    private final StringProperty keyPatternReplacementProperty = new SimpleStringProperty();
    private final StringProperty unwantedCharactersProperty = new SimpleStringProperty();
    private final ListProperty<CitationKeyPatternsPanelItemModel> patternListProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<CitationKeyPatternsPanelItemModel> defaultKeyPatternProperty = new SimpleObjectProperty((Object)new CitationKeyPatternsPanelItemModel(new CitationKeyPatternsPanelViewModel.DefaultEntryType(), ""));
    private final CitationKeyPatternPreferences keyPatternPreferences;

    public CitationKeyPatternTabViewModel(CitationKeyPatternPreferences keyPatternPreferences) {
        this.keyPatternPreferences = keyPatternPreferences;
    }

    @Override
    public void setValues() {
        this.overwriteAllowProperty.setValue(Boolean.valueOf(!this.keyPatternPreferences.shouldAvoidOverwriteCiteKey()));
        this.overwriteWarningProperty.setValue(Boolean.valueOf(this.keyPatternPreferences.shouldWarnBeforeOverwriteCiteKey()));
        this.generateOnSaveProperty.setValue(Boolean.valueOf(this.keyPatternPreferences.shouldGenerateCiteKeysBeforeSaving()));
        if (this.keyPatternPreferences.getKeySuffix() == CitationKeyPatternPreferences.KeySuffix.ALWAYS) {
            this.letterAlwaysAddProperty.setValue(Boolean.valueOf(true));
            this.letterStartAProperty.setValue(Boolean.valueOf(false));
            this.letterStartBProperty.setValue(Boolean.valueOf(false));
        } else if (this.keyPatternPreferences.getKeySuffix() == CitationKeyPatternPreferences.KeySuffix.SECOND_WITH_A) {
            this.letterAlwaysAddProperty.setValue(Boolean.valueOf(false));
            this.letterStartAProperty.setValue(Boolean.valueOf(true));
            this.letterStartBProperty.setValue(Boolean.valueOf(false));
        } else {
            this.letterAlwaysAddProperty.setValue(Boolean.valueOf(false));
            this.letterStartAProperty.setValue(Boolean.valueOf(false));
            this.letterStartBProperty.setValue(Boolean.valueOf(true));
        }
        this.keyPatternRegexProperty.setValue(this.keyPatternPreferences.getKeyPatternRegex());
        this.keyPatternReplacementProperty.setValue(this.keyPatternPreferences.getKeyPatternReplacement());
        this.unwantedCharactersProperty.setValue(this.keyPatternPreferences.getUnwantedCharacters());
    }

    @Override
    public void storeSettings() {
        GlobalCitationKeyPatterns newKeyPattern = new GlobalCitationKeyPatterns(this.keyPatternPreferences.getKeyPatterns().getDefaultValue());
        this.patternListProperty.forEach(item -> {
            String patternString = item.getPattern();
            if (!"default".equals(item.getEntryType().getName()) && !patternString.trim().isEmpty()) {
                newKeyPattern.addCitationKeyPattern(item.getEntryType(), patternString);
            }
        });
        if (!((CitationKeyPatternsPanelItemModel)this.defaultKeyPatternProperty.getValue()).getPattern().trim().isEmpty()) {
            newKeyPattern.setDefaultValue(((CitationKeyPatternsPanelItemModel)this.defaultKeyPatternProperty.getValue()).getPattern());
        }
        CitationKeyPatternPreferences.KeySuffix keySuffix = CitationKeyPatternPreferences.KeySuffix.ALWAYS;
        if (this.letterStartAProperty.getValue().booleanValue()) {
            keySuffix = CitationKeyPatternPreferences.KeySuffix.SECOND_WITH_A;
        } else if (this.letterStartBProperty.getValue().booleanValue()) {
            keySuffix = CitationKeyPatternPreferences.KeySuffix.SECOND_WITH_B;
        }
        this.keyPatternPreferences.setAvoidOverwriteCiteKey(this.overwriteAllowProperty.getValue() == false);
        this.keyPatternPreferences.setWarnBeforeOverwriteCiteKey(this.overwriteWarningProperty.getValue());
        this.keyPatternPreferences.setGenerateCiteKeysBeforeSaving(this.generateOnSaveProperty.getValue());
        this.keyPatternPreferences.setKeySuffix(keySuffix);
        this.keyPatternPreferences.setKeyPatternRegex(this.keyPatternRegexProperty.getValue());
        this.keyPatternPreferences.setKeyPatternReplacement(this.keyPatternReplacementProperty.getValue());
        this.keyPatternPreferences.setUnwantedCharacters(this.unwantedCharactersProperty.getValue());
        this.keyPatternPreferences.setKeyPatterns(newKeyPattern);
    }

    public BooleanProperty overwriteAllowProperty() {
        return this.overwriteAllowProperty;
    }

    public BooleanProperty overwriteWarningProperty() {
        return this.overwriteWarningProperty;
    }

    public BooleanProperty generateOnSaveProperty() {
        return this.generateOnSaveProperty;
    }

    public BooleanProperty letterStartAProperty() {
        return this.letterStartAProperty;
    }

    public BooleanProperty letterStartBProperty() {
        return this.letterStartBProperty;
    }

    public BooleanProperty letterAlwaysAddProperty() {
        return this.letterAlwaysAddProperty;
    }

    public StringProperty keyPatternRegexProperty() {
        return this.keyPatternRegexProperty;
    }

    public StringProperty keyPatternReplacementProperty() {
        return this.keyPatternReplacementProperty;
    }

    public ListProperty<CitationKeyPatternsPanelItemModel> patternListProperty() {
        return this.patternListProperty;
    }

    public ObjectProperty<CitationKeyPatternsPanelItemModel> defaultKeyPatternProperty() {
        return this.defaultKeyPatternProperty;
    }

    public StringProperty unwantedCharactersProperty() {
        return this.unwantedCharactersProperty;
    }
}

