/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.customimporter;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import org.jabref.gui.importer.ImporterViewModel;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.customimporter.CustomImporterTabViewModel;
import org.jabref.gui.util.ViewModelTableRowFactory;
import org.jabref.logic.l10n.Localization;

public class CustomImporterTab
extends AbstractPreferenceTabView<CustomImporterTabViewModel>
implements PreferencesTab {
    @FXML
    private TableView<ImporterViewModel> importerTable;
    @FXML
    private TableColumn<ImporterViewModel, String> nameColumn;
    @FXML
    private TableColumn<ImporterViewModel, String> classColumn;
    @FXML
    private TableColumn<ImporterViewModel, String> basePathColumn;
    @FXML
    private Button addButton;

    public CustomImporterTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Custom import formats", new Object[0]);
    }

    @FXML
    private void initialize() {
        this.viewModel = new CustomImporterTabViewModel(this.preferencesService, this.dialogService);
        this.importerTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.importerTable.itemsProperty().bind(((CustomImporterTabViewModel)this.viewModel).importersProperty());
        EasyBind.bindContent(((CustomImporterTabViewModel)this.viewModel).selectedImportersProperty(), (ObservableList)this.importerTable.getSelectionModel().getSelectedItems());
        this.nameColumn.setCellValueFactory(cellData -> ((ImporterViewModel)cellData.getValue()).name());
        this.classColumn.setCellValueFactory(cellData -> ((ImporterViewModel)cellData.getValue()).className());
        this.basePathColumn.setCellValueFactory(cellData -> ((ImporterViewModel)cellData.getValue()).basePath());
        new ViewModelTableRowFactory().withTooltip(importer -> importer.getLogic().getDescription()).install(this.importerTable);
        this.addButton.setTooltip(new Tooltip(Localization.lang("Add a (compiled) custom Importer class from a class path.", new Object[0]) + "\n" + Localization.lang("The path need not be on the classpath of JabRef.", new Object[0])));
    }

    @FXML
    private void add() {
        ((CustomImporterTabViewModel)this.viewModel).addImporter();
    }

    @FXML
    private void remove() {
        ((CustomImporterTabViewModel)this.viewModel).removeSelectedImporter();
    }
}

