/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.customimporter;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.jabref.gui.DialogService;
import org.jabref.gui.importer.ImporterViewModel;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.importer.ImportException;
import org.jabref.logic.importer.fileformat.CustomImporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomImporterTabViewModel
implements PreferenceTabViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomImporterTabViewModel.class);
    private final ListProperty<ImporterViewModel> importers = new SimpleListProperty(FXCollections.observableArrayList());
    private final ListProperty<ImporterViewModel> selectedImporters = new SimpleListProperty(FXCollections.observableArrayList());
    private final PreferencesService preferences;
    private final DialogService dialogService;

    public CustomImporterTabViewModel(PreferencesService preferences, DialogService dialogService) {
        this.preferences = preferences;
        this.dialogService = dialogService;
    }

    @Override
    public void setValues() {
        ObservableSet<CustomImporter> importersLogic = this.preferences.getImporterPreferences().getCustomImporters();
        this.importers.clear();
        for (CustomImporter importer : importersLogic) {
            this.importers.add((Object)new ImporterViewModel(importer));
        }
    }

    @Override
    public void storeSettings() {
        this.preferences.getImporterPreferences().setCustomImporters(this.importers.stream().map(ImporterViewModel::getLogic).collect(Collectors.toSet()));
    }

    private static String pathToClass(String basePath, Path path) {
        String className = FileUtil.relativize(path, Collections.singletonList(Path.of(basePath, new String[0]))).toString();
        if (className != null) {
            int lastDot = className.lastIndexOf(46);
            if (lastDot < 0) {
                return className;
            }
            className = className.substring(0, lastDot);
        }
        return className;
    }

    public void addImporter() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.CLASS, StandardFileType.JAR, StandardFileType.ZIP).withDefaultExtension(StandardFileType.CLASS).withInitialDirectory(this.preferences.getFilePreferences().getWorkingDirectory()).build();
        Optional<Path> selectedFile = this.dialogService.showFileOpenDialog(fileDialogConfiguration);
        if (selectedFile.isPresent() && selectedFile.get().getParent() != null) {
            boolean isArchive = FileUtil.getFileExtension(selectedFile.get()).filter(extension -> "jar".equalsIgnoreCase((String)extension) || "zip".equalsIgnoreCase((String)extension)).isPresent();
            if (isArchive) {
                try {
                    Optional<Path> selectedFileInArchive = this.dialogService.showFileOpenFromArchiveDialog(selectedFile.get());
                    if (selectedFileInArchive.isPresent()) {
                        String className = selectedFileInArchive.get().toString().substring(0, selectedFileInArchive.get().toString().lastIndexOf(46)).replace("/", ".");
                        CustomImporter importer = new CustomImporter(selectedFile.get().toAbsolutePath().toString(), className);
                        this.importers.add((Object)new ImporterViewModel(importer));
                    }
                }
                catch (IOException exc) {
                    LOGGER.error("Could not open ZIP-archive.", (Throwable)exc);
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Could not open %0", selectedFile.get().toString()) + "\n" + Localization.lang("Have you chosen the correct package path?", new Object[0]), exc);
                }
                catch (ImportException exc) {
                    LOGGER.error("Could not instantiate importer", (Throwable)exc);
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Could not instantiate %0 %1", "importer"), exc);
                }
            } else {
                try {
                    String basePath = selectedFile.get().getParent().toString();
                    String className = CustomImporterTabViewModel.pathToClass(basePath, selectedFile.get());
                    CustomImporter importer = new CustomImporter(basePath, className);
                    this.importers.add((Object)new ImporterViewModel(importer));
                }
                catch (Exception exc) {
                    LOGGER.error("Could not instantiate importer", (Throwable)exc);
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Could not instantiate %0", selectedFile.get().toString()), exc);
                }
                catch (NoClassDefFoundError exc) {
                    LOGGER.error("Could not find class while instantiating importer", (Throwable)exc);
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Could not instantiate %0. Have you chosen the correct package path?", selectedFile.get().toString()), exc);
                }
            }
        }
    }

    public void removeSelectedImporter() {
        this.importers.removeAll(this.selectedImporters);
    }

    public ListProperty<ImporterViewModel> selectedImportersProperty() {
        return this.selectedImporters;
    }

    public ListProperty<ImporterViewModel> importersProperty() {
        return this.importers;
    }
}

