/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.entryeditor;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.commands.Command;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.entryeditor.EntryEditorTabViewModel;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;

public class EntryEditorTab
extends AbstractPreferenceTabView<EntryEditorTabViewModel>
implements PreferencesTab {
    @FXML
    private CheckBox openOnNewEntry;
    @FXML
    private CheckBox defaultSource;
    @FXML
    private CheckBox enableRelatedArticlesTab;
    @FXML
    private CheckBox acceptRecommendations;
    @FXML
    private CheckBox enableLatexCitationsTab;
    @FXML
    private CheckBox enableValidation;
    @FXML
    private CheckBox allowIntegerEdition;
    @FXML
    private CheckBox journalPopupEnabled;
    @FXML
    private CheckBox autoLinkFilesEnabled;
    @FXML
    private CheckBox enableSciteTab;
    @FXML
    private CheckBox showUserCommentsField;
    @FXML
    private Button generalFieldsHelp;
    @FXML
    private TextArea fieldsTextArea;

    public EntryEditorTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Entry editor", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new EntryEditorTabViewModel(this.dialogService, this.preferencesService);
        this.openOnNewEntry.selectedProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).openOnNewEntryProperty());
        this.defaultSource.selectedProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).defaultSourceProperty());
        this.enableRelatedArticlesTab.selectedProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).enableRelatedArticlesTabProperty());
        this.acceptRecommendations.selectedProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).acceptRecommendationsProperty());
        this.enableLatexCitationsTab.selectedProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).enableLatexCitationsTabProperty());
        this.enableValidation.selectedProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).enableValidationProperty());
        this.allowIntegerEdition.selectedProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).allowIntegerEditionProperty());
        this.journalPopupEnabled.selectedProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).journalPopupProperty());
        this.autoLinkFilesEnabled.selectedProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).autoLinkFilesEnabledProperty());
        this.enableSciteTab.selectedProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).enableSciteTabProperty());
        this.showUserCommentsField.selectedProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).showUserCommentsProperty());
        this.fieldsTextArea.textProperty().bindBidirectional((Property)((EntryEditorTabViewModel)this.viewModel).fieldsProperty());
        ActionFactory actionFactory = new ActionFactory();
        actionFactory.configureIconButton(StandardActions.HELP, (Command)new HelpAction(HelpFile.GENERAL_FIELDS, this.dialogService, this.preferencesService.getFilePreferences()), (ButtonBase)this.generalFieldsHelp);
    }

    @FXML
    void resetToDefaults() {
        ((EntryEditorTabViewModel)this.viewModel).resetToDefaults();
    }
}

