/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.entryeditor;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.gui.DialogService;
import org.jabref.gui.entryeditor.EntryEditorPreferences;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.logic.citationkeypattern.CitationKeyGenerator;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.preferences.MrDlibPreferences;
import org.jabref.preferences.PreferencesService;

public class EntryEditorTabViewModel
implements PreferenceTabViewModel {
    private final BooleanProperty openOnNewEntryProperty = new SimpleBooleanProperty();
    private final BooleanProperty defaultSourceProperty = new SimpleBooleanProperty();
    private final BooleanProperty enableRelatedArticlesTabProperty = new SimpleBooleanProperty();
    private final BooleanProperty acceptRecommendationsProperty = new SimpleBooleanProperty();
    private final BooleanProperty enableLatexCitationsTabProperty = new SimpleBooleanProperty();
    private final BooleanProperty enableValidationProperty = new SimpleBooleanProperty();
    private final BooleanProperty allowIntegerEditionProperty = new SimpleBooleanProperty();
    private final BooleanProperty journalPopupProperty = new SimpleBooleanProperty();
    private final BooleanProperty autoLinkEnabledProperty = new SimpleBooleanProperty();
    private final BooleanProperty enableSciteTabProperty = new SimpleBooleanProperty();
    private final BooleanProperty showUserCommentsProperty = new SimpleBooleanProperty();
    private final StringProperty fieldsProperty = new SimpleStringProperty();
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final EntryEditorPreferences entryEditorPreferences;
    private final MrDlibPreferences mrDlibPreferences;

    public EntryEditorTabViewModel(DialogService dialogService, PreferencesService preferencesService) {
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.entryEditorPreferences = preferencesService.getEntryEditorPreferences();
        this.mrDlibPreferences = preferencesService.getMrDlibPreferences();
    }

    @Override
    public void setValues() {
        this.openOnNewEntryProperty.setValue(Boolean.valueOf(this.entryEditorPreferences.shouldOpenOnNewEntry()));
        this.defaultSourceProperty.setValue(Boolean.valueOf(this.entryEditorPreferences.showSourceTabByDefault()));
        this.enableRelatedArticlesTabProperty.setValue(Boolean.valueOf(this.entryEditorPreferences.shouldShowRecommendationsTab()));
        this.acceptRecommendationsProperty.setValue(Boolean.valueOf(this.mrDlibPreferences.shouldAcceptRecommendations()));
        this.enableLatexCitationsTabProperty.setValue(Boolean.valueOf(this.entryEditorPreferences.shouldShowLatexCitationsTab()));
        this.enableValidationProperty.setValue(Boolean.valueOf(this.entryEditorPreferences.shouldEnableValidation()));
        this.allowIntegerEditionProperty.setValue(Boolean.valueOf(this.entryEditorPreferences.shouldAllowIntegerEditionBibtex()));
        this.journalPopupProperty.setValue(Boolean.valueOf(this.entryEditorPreferences.shouldEnableJournalPopup() == EntryEditorPreferences.JournalPopupEnabled.ENABLED));
        this.autoLinkEnabledProperty.setValue(Boolean.valueOf(this.entryEditorPreferences.autoLinkFilesEnabled()));
        this.enableSciteTabProperty.setValue(Boolean.valueOf(this.entryEditorPreferences.shouldShowSciteTab()));
        this.showUserCommentsProperty.setValue(Boolean.valueOf(this.entryEditorPreferences.shouldShowUserCommentsFields()));
        this.setFields((Map<String, Set<Field>>)this.entryEditorPreferences.getEntryEditorTabs());
    }

    public void resetToDefaults() {
        this.setFields((Map<String, Set<Field>>)this.preferencesService.getEntryEditorPreferences().getDefaultEntryEditorTabs());
    }

    private void setFields(Map<String, Set<Field>> tabNamesAndFields) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<Field>> tab : tabNamesAndFields.entrySet()) {
            sb.append(tab.getKey());
            sb.append(':');
            sb.append(FieldFactory.serializeFieldsList((Collection<Field>)tab.getValue()));
            sb.append('\n');
        }
        this.fieldsProperty.set((Object)sb.toString());
    }

    @Override
    public void storeSettings() {
        String[] lines;
        this.entryEditorPreferences.setShouldOpenOnNewEntry(this.openOnNewEntryProperty.getValue());
        this.entryEditorPreferences.setShouldShowRecommendationsTab(this.enableRelatedArticlesTabProperty.getValue());
        this.mrDlibPreferences.setAcceptRecommendations(this.acceptRecommendationsProperty.getValue());
        this.entryEditorPreferences.setShouldShowLatexCitationsTab(this.enableLatexCitationsTabProperty.getValue());
        this.entryEditorPreferences.setShowSourceTabByDefault(this.defaultSourceProperty.getValue());
        this.entryEditorPreferences.setEnableValidation(this.enableValidationProperty.getValue());
        this.entryEditorPreferences.setAllowIntegerEditionBibtex(this.allowIntegerEditionProperty.getValue());
        this.entryEditorPreferences.setEnableJournalPopup(this.journalPopupProperty.getValue() != false ? EntryEditorPreferences.JournalPopupEnabled.ENABLED : EntryEditorPreferences.JournalPopupEnabled.DISABLED);
        this.entryEditorPreferences.setAutoLinkFilesEnabled(this.autoLinkEnabledProperty.getValue());
        this.entryEditorPreferences.setShouldShowSciteTab(this.enableSciteTabProperty.getValue());
        this.entryEditorPreferences.setShowUserCommentsFields(this.showUserCommentsProperty.getValue());
        LinkedHashMap<String, Set<Field>> customTabsMap = new LinkedHashMap<String, Set<Field>>();
        for (String line : lines = ((String)this.fieldsProperty.get()).split("\n")) {
            String[] parts = line.split(":");
            if (parts.length != 2) {
                this.dialogService.showInformationDialogAndWait(Localization.lang("Error", new Object[0]), Localization.lang("Each line must be of the following form: 'tab:field1;field2;...;fieldN'.", new Object[0]));
                return;
            }
            String unwantedChars = "#{}()~,^&-\"'`\u02b9\\";
            String testString = CitationKeyGenerator.cleanKey(parts[1], unwantedChars);
            if (!testString.equals(parts[1])) {
                this.dialogService.showInformationDialogAndWait(Localization.lang("Error", new Object[0]), Localization.lang("Field names are not allowed to contain white spaces or certain characters (%0).", "# { } ( ) ~ , ^ & - \" ' ` \u02b9 \\"));
                return;
            }
            customTabsMap.put(parts[0], FieldFactory.parseFieldList(parts[1]));
        }
        this.entryEditorPreferences.setEntryEditorTabList(customTabsMap);
    }

    public BooleanProperty openOnNewEntryProperty() {
        return this.openOnNewEntryProperty;
    }

    public BooleanProperty defaultSourceProperty() {
        return this.defaultSourceProperty;
    }

    public BooleanProperty enableRelatedArticlesTabProperty() {
        return this.enableRelatedArticlesTabProperty;
    }

    public BooleanProperty acceptRecommendationsProperty() {
        return this.acceptRecommendationsProperty;
    }

    public BooleanProperty enableLatexCitationsTabProperty() {
        return this.enableLatexCitationsTabProperty;
    }

    public BooleanProperty enableValidationProperty() {
        return this.enableValidationProperty;
    }

    public BooleanProperty allowIntegerEditionProperty() {
        return this.allowIntegerEditionProperty;
    }

    public BooleanProperty journalPopupProperty() {
        return this.journalPopupProperty;
    }

    public StringProperty fieldsProperty() {
        return this.fieldsProperty;
    }

    public BooleanProperty autoLinkFilesEnabledProperty() {
        return this.autoLinkEnabledProperty;
    }

    public BooleanProperty enableSciteTabProperty() {
        return this.enableSciteTabProperty;
    }

    public BooleanProperty showUserCommentsProperty() {
        return this.showUserCommentsProperty;
    }
}

