/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.external;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.external.ExternalTabViewModel;
import org.jabref.gui.push.PushToApplication;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;

public class ExternalTab
extends AbstractPreferenceTabView<ExternalTabViewModel>
implements PreferencesTab {
    @FXML
    private TextField eMailReferenceSubject;
    @FXML
    private CheckBox autoOpenAttachedFolders;
    @FXML
    private ComboBox<PushToApplication> pushToApplicationCombo;
    @FXML
    private TextField citeCommand;
    @FXML
    private Button autolinkExternalHelp;
    @FXML
    private CheckBox useCustomTerminal;
    @FXML
    private TextField customTerminalCommand;
    @FXML
    private Button customTerminalBrowse;
    @FXML
    private CheckBox useCustomFileBrowser;
    @FXML
    private TextField customFileBrowserCommand;
    @FXML
    private Button customFileBrowserBrowse;
    @FXML
    private TextField kindleEmail;
    private final ControlsFxVisualizer validationVisualizer = new ControlsFxVisualizer();

    public ExternalTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("External programs", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new ExternalTabViewModel(this.dialogService, this.preferencesService);
        new ViewModelListCellFactory().withText(PushToApplication::getDisplayName).withIcon(PushToApplication::getApplicationIcon).install(this.pushToApplicationCombo);
        this.eMailReferenceSubject.textProperty().bindBidirectional((Property)((ExternalTabViewModel)this.viewModel).eMailReferenceSubjectProperty());
        this.autoOpenAttachedFolders.selectedProperty().bindBidirectional((Property)((ExternalTabViewModel)this.viewModel).autoOpenAttachedFoldersProperty());
        this.pushToApplicationCombo.itemsProperty().bind(((ExternalTabViewModel)this.viewModel).pushToApplicationsListProperty());
        this.pushToApplicationCombo.valueProperty().bindBidirectional(((ExternalTabViewModel)this.viewModel).selectedPushToApplication());
        this.citeCommand.textProperty().bindBidirectional((Property)((ExternalTabViewModel)this.viewModel).citeCommandProperty());
        this.useCustomTerminal.selectedProperty().bindBidirectional((Property)((ExternalTabViewModel)this.viewModel).useCustomTerminalProperty());
        this.customTerminalCommand.textProperty().bindBidirectional((Property)((ExternalTabViewModel)this.viewModel).customTerminalCommandProperty());
        this.customTerminalCommand.disableProperty().bind((ObservableValue)this.useCustomTerminal.selectedProperty().not());
        this.customTerminalBrowse.disableProperty().bind((ObservableValue)this.useCustomTerminal.selectedProperty().not());
        this.useCustomFileBrowser.selectedProperty().bindBidirectional((Property)((ExternalTabViewModel)this.viewModel).useCustomFileBrowserProperty());
        this.customFileBrowserCommand.textProperty().bindBidirectional((Property)((ExternalTabViewModel)this.viewModel).customFileBrowserCommandProperty());
        this.customFileBrowserCommand.disableProperty().bind((ObservableValue)this.useCustomFileBrowser.selectedProperty().not());
        this.customFileBrowserBrowse.disableProperty().bind((ObservableValue)this.useCustomFileBrowser.selectedProperty().not());
        this.kindleEmail.textProperty().bindBidirectional((Property)((ExternalTabViewModel)this.viewModel).kindleEmailProperty());
        this.validationVisualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        Platform.runLater(() -> {
            this.validationVisualizer.initVisualization(((ExternalTabViewModel)this.viewModel).terminalCommandValidationStatus(), (Control)this.customTerminalCommand);
            this.validationVisualizer.initVisualization(((ExternalTabViewModel)this.viewModel).fileBrowserCommandValidationStatus(), (Control)this.customFileBrowserCommand);
        });
        ActionFactory actionFactory = new ActionFactory();
        actionFactory.configureIconButton(StandardActions.HELP_PUSH_TO_APPLICATION, (Command)new HelpAction(HelpFile.PUSH_TO_APPLICATION, this.dialogService, this.preferencesService.getFilePreferences()), (ButtonBase)this.autolinkExternalHelp);
    }

    @FXML
    void pushToApplicationSettings() {
        ((ExternalTabViewModel)this.viewModel).pushToApplicationSettings();
    }

    @FXML
    void useTerminalCommandBrowse() {
        ((ExternalTabViewModel)this.viewModel).customTerminalBrowse();
    }

    @FXML
    void useFileBrowserSpecialCommandBrowse() {
        ((ExternalTabViewModel)this.viewModel).customFileBrowserBrowse();
    }

    @FXML
    void resetCiteCommandToDefault() {
        ((ExternalTabViewModel)this.viewModel).resetCiteCommandToDefault();
    }
}

