/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.externalfiletypes;

import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.HashSet;
import java.util.function.Predicate;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.exporter.CreateModifyExporterDialogViewModel;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.preferences.externalfiletypes.EditExternalFileTypeEntryDialog;
import org.jabref.gui.preferences.externalfiletypes.ExternalFileTypeItemViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.FilePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFileTypesTabViewModel
implements PreferenceTabViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateModifyExporterDialogViewModel.class);
    private final ObservableList<ExternalFileTypeItemViewModel> fileTypes = FXCollections.observableArrayList();
    private final FilePreferences filePreferences;
    private final DialogService dialogService;

    public ExternalFileTypesTabViewModel(FilePreferences filePreferences, DialogService dialogService) {
        this.filePreferences = filePreferences;
        this.dialogService = dialogService;
    }

    @Override
    public void setValues() {
        this.fileTypes.clear();
        this.fileTypes.addAll(this.filePreferences.getExternalFileTypes().stream().map(ExternalFileTypeItemViewModel::new).toList());
        this.fileTypes.sort(Comparator.comparing(ExternalFileTypeItemViewModel::getName));
    }

    @Override
    public void storeSettings() {
        HashSet saveList = new HashSet();
        this.fileTypes.stream().map(ExternalFileTypeItemViewModel::toExternalFileType).forEach(type -> ExternalFileTypes.getDefaultExternalFileTypes().stream().filter((Predicate<ExternalFileType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/jabref/gui/externalfiletype/ExternalFileType;)Z)((ExternalFileType)type)).findAny().ifPresentOrElse(saveList::add, () -> saveList.add(type)));
        this.filePreferences.getExternalFileTypes().clear();
        this.filePreferences.getExternalFileTypes().addAll(saveList);
    }

    public void resetToDefaults() {
        this.fileTypes.setAll(ExternalFileTypes.getDefaultExternalFileTypes().stream().map(ExternalFileTypeItemViewModel::new).toList());
        this.fileTypes.sort(Comparator.comparing(ExternalFileTypeItemViewModel::getName));
    }

    public boolean addNewType() {
        ExternalFileTypeItemViewModel item = new ExternalFileTypeItemViewModel();
        this.showEditDialog(item, Localization.lang("Add new file type", new Object[0]));
        if (!this.isValidExternalFileType(item)) {
            return false;
        }
        this.fileTypes.add((Object)item);
        return true;
    }

    public ObservableList<ExternalFileTypeItemViewModel> getFileTypes() {
        return this.fileTypes;
    }

    protected void showEditDialog(ExternalFileTypeItemViewModel item, String dialogTitle) {
        this.dialogService.showCustomDialogAndWait(new EditExternalFileTypeEntryDialog(item, dialogTitle, this.fileTypes));
    }

    public boolean edit(ExternalFileTypeItemViewModel type) {
        ExternalFileTypeItemViewModel typeToModify = new ExternalFileTypeItemViewModel(type.toExternalFileType());
        this.showEditDialog(typeToModify, Localization.lang("Edit file type", new Object[0]));
        if (!this.isValidExternalFileType(typeToModify)) {
            return false;
        }
        this.fileTypes.remove((Object)type);
        this.fileTypes.add((Object)typeToModify);
        return true;
    }

    public void remove(ExternalFileTypeItemViewModel type) {
        this.fileTypes.remove((Object)type);
    }

    public boolean isValidExternalFileType(ExternalFileTypeItemViewModel item) {
        if (this.withEmptyValue(item)) {
            LOGGER.debug("One of the fields is empty or invalid.");
            return false;
        }
        if (!this.isUniqueExtension(item)) {
            LOGGER.debug("File Extension exists already.");
            return false;
        }
        return true;
    }

    private boolean withEmptyValue(ExternalFileTypeItemViewModel item) {
        return item.getName().isEmpty() || ((String)item.extensionProperty().get()).isEmpty() || ((String)item.mimetypeProperty().get()).isEmpty();
    }

    private boolean isUniqueExtension(ExternalFileTypeItemViewModel item) {
        String newExt = (String)item.extensionProperty().get();
        for (ExternalFileTypeItemViewModel fileTypeItem : this.fileTypes) {
            if (!newExt.equalsIgnoreCase((String)fileTypeItem.extensionProperty().get())) continue;
            return false;
        }
        return true;
    }
}

