/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.general;

import com.airhacks.afterburner.injection.Injector;
import de.saxsys.mvvmfx.utils.validation.CompositeValidator;
import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.control.SpinnerValueFactory;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.frame.UiMessageHandler;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.remote.CLIMessageHandler;
import org.jabref.gui.theme.Theme;
import org.jabref.gui.theme.ThemeTypes;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Language;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.net.ssl.TrustStoreManager;
import org.jabref.logic.remote.RemotePreferences;
import org.jabref.logic.remote.RemoteUtil;
import org.jabref.logic.remote.server.RemoteListenerServerManager;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.InternalPreferences;
import org.jabref.preferences.LibraryPreferences;
import org.jabref.preferences.MergeDialogPreferences;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.WorkspacePreferences;

public class GeneralTabViewModel
implements PreferenceTabViewModel {
    protected static SpinnerValueFactory<Integer> fontSizeValueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(9, Integer.MAX_VALUE);
    private final ReadOnlyListProperty<Language> languagesListProperty = new ReadOnlyListWrapper(FXCollections.observableArrayList(Language.getSorted()));
    private final ObjectProperty<Language> selectedLanguageProperty = new SimpleObjectProperty();
    private final ReadOnlyListProperty<ThemeTypes> themesListProperty = new ReadOnlyListWrapper(FXCollections.observableArrayList((Object[])ThemeTypes.values()));
    private final ObjectProperty<ThemeTypes> selectedThemeProperty = new SimpleObjectProperty();
    private final BooleanProperty themeSyncOsProperty = new SimpleBooleanProperty();
    private final StringProperty customPathToThemeProperty = new SimpleStringProperty();
    private final BooleanProperty fontOverrideProperty = new SimpleBooleanProperty();
    private final StringProperty fontSizeProperty = new SimpleStringProperty();
    private final BooleanProperty openLastStartupProperty = new SimpleBooleanProperty();
    private final BooleanProperty showAdvancedHintsProperty = new SimpleBooleanProperty();
    private final BooleanProperty inspectionWarningDuplicateProperty = new SimpleBooleanProperty();
    private final BooleanProperty confirmDeleteProperty = new SimpleBooleanProperty();
    private final ListProperty<BibDatabaseMode> bibliographyModeListProperty = new SimpleListProperty();
    private final ObjectProperty<BibDatabaseMode> selectedBiblatexModeProperty = new SimpleObjectProperty();
    private final BooleanProperty alwaysReformatBibProperty = new SimpleBooleanProperty();
    private final BooleanProperty autosaveLocalLibraries = new SimpleBooleanProperty();
    private final BooleanProperty createBackupProperty = new SimpleBooleanProperty();
    private final StringProperty backupDirectoryProperty = new SimpleStringProperty("");
    private final DialogService dialogService;
    private final PreferencesService preferences;
    private final WorkspacePreferences workspacePreferences;
    private final LibraryPreferences libraryPreferences;
    private final FilePreferences filePreferences;
    private final RemotePreferences remotePreferences;
    private final MergeDialogPreferences mergeDialogPreferences;
    private final Validator fontSizeValidator;
    private final Validator customPathToThemeValidator;
    private final List<String> restartWarning = new ArrayList<String>();
    private final BooleanProperty remoteServerProperty = new SimpleBooleanProperty();
    private final StringProperty remotePortProperty = new SimpleStringProperty("");
    private final Validator remotePortValidator;
    private final InternalPreferences internalPreferences;
    private final BooleanProperty versionCheckProperty = new SimpleBooleanProperty();
    private final FileUpdateMonitor fileUpdateMonitor;
    private final BibEntryTypesManager entryTypesManager;
    private final TrustStoreManager trustStoreManager;

    public GeneralTabViewModel(DialogService dialogService, PreferencesService preferences, FileUpdateMonitor fileUpdateMonitor, BibEntryTypesManager entryTypesManager) {
        this.dialogService = dialogService;
        this.preferences = preferences;
        this.workspacePreferences = preferences.getWorkspacePreferences();
        this.libraryPreferences = preferences.getLibraryPreferences();
        this.filePreferences = preferences.getFilePreferences();
        this.remotePreferences = preferences.getRemotePreferences();
        this.internalPreferences = preferences.getInternalPreferences();
        this.mergeDialogPreferences = preferences.getMergeDialogPreferences();
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.entryTypesManager = entryTypesManager;
        this.fontSizeValidator = new FunctionBasedValidator((ObservableValue)this.fontSizeProperty, input -> {
            try {
                return Integer.parseInt(this.fontSizeProperty().getValue()) > 8;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }, ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("General", new Object[0]), Localization.lang("Font settings", new Object[0]), Localization.lang("You must enter an integer value higher than 8.", new Object[0]))));
        this.customPathToThemeValidator = new FunctionBasedValidator((ObservableValue)this.customPathToThemeProperty, input -> !StringUtil.isNullOrEmpty(input), ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("General", new Object[0]), Localization.lang("Visual theme", new Object[0]), Localization.lang("Please specify a css theme file.", new Object[0]))));
        this.remotePortValidator = new FunctionBasedValidator((ObservableValue)this.remotePortProperty, input -> {
            try {
                int portNumber = Integer.parseInt(this.remotePortProperty().getValue());
                return RemoteUtil.isUserPort(portNumber);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }, ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("Network", new Object[0]), Localization.lang("Remote operation", new Object[0]), Localization.lang("You must enter an integer value in the interval 1025-65535", new Object[0]))));
        this.trustStoreManager = new TrustStoreManager(Path.of(preferences.getSSLPreferences().getTruststorePath(), new String[0]));
    }

    public ValidationStatus remotePortValidationStatus() {
        return this.remotePortValidator.getValidationStatus();
    }

    @Override
    public void setValues() {
        this.selectedLanguageProperty.setValue((Object)this.workspacePreferences.getLanguage());
        switch (this.workspacePreferences.getTheme().getType()) {
            case DEFAULT: {
                this.selectedThemeProperty.setValue((Object)ThemeTypes.LIGHT);
                break;
            }
            case EMBEDDED: {
                this.selectedThemeProperty.setValue((Object)ThemeTypes.DARK);
                break;
            }
            case CUSTOM: {
                this.selectedThemeProperty.setValue((Object)ThemeTypes.CUSTOM);
                this.customPathToThemeProperty.setValue(this.workspacePreferences.getTheme().getName());
            }
        }
        this.themeSyncOsProperty.setValue(Boolean.valueOf(this.workspacePreferences.shouldThemeSyncOs()));
        this.fontOverrideProperty.setValue(Boolean.valueOf(this.workspacePreferences.shouldOverrideDefaultFontSize()));
        this.fontSizeProperty.setValue(String.valueOf(this.workspacePreferences.getMainFontSize()));
        this.openLastStartupProperty.setValue(Boolean.valueOf(this.workspacePreferences.shouldOpenLastEdited()));
        this.showAdvancedHintsProperty.setValue(Boolean.valueOf(this.workspacePreferences.shouldShowAdvancedHints()));
        this.inspectionWarningDuplicateProperty.setValue(Boolean.valueOf(this.workspacePreferences.shouldWarnAboutDuplicatesInInspection()));
        this.confirmDeleteProperty.setValue(Boolean.valueOf(this.workspacePreferences.shouldConfirmDelete()));
        this.bibliographyModeListProperty.setValue(FXCollections.observableArrayList((Object[])BibDatabaseMode.values()));
        this.selectedBiblatexModeProperty.setValue((Object)this.libraryPreferences.getDefaultBibDatabaseMode());
        this.alwaysReformatBibProperty.setValue(Boolean.valueOf(this.libraryPreferences.shouldAlwaysReformatOnSave()));
        this.autosaveLocalLibraries.setValue(Boolean.valueOf(this.libraryPreferences.shouldAutoSave()));
        this.createBackupProperty.setValue(Boolean.valueOf(this.filePreferences.shouldCreateBackup()));
        this.backupDirectoryProperty.setValue(this.filePreferences.getBackupDirectory().toString());
        this.remoteServerProperty.setValue(Boolean.valueOf(this.remotePreferences.useRemoteServer()));
        this.remotePortProperty.setValue(String.valueOf(this.remotePreferences.getPort()));
    }

    @Override
    public void storeSettings() {
        Language newLanguage = (Language)((Object)this.selectedLanguageProperty.getValue());
        if (newLanguage != this.workspacePreferences.getLanguage()) {
            this.workspacePreferences.setLanguage(newLanguage);
            Localization.setLanguage(newLanguage);
            this.restartWarning.add(Localization.lang("Changed language", new Object[0]) + ": " + newLanguage.getDisplayName());
        }
        this.workspacePreferences.setShouldOverrideDefaultFontSize(this.fontOverrideProperty.getValue());
        this.workspacePreferences.setMainFontSize(Integer.parseInt(this.fontSizeProperty.getValue()));
        switch ((ThemeTypes)((Object)this.selectedThemeProperty.get())) {
            case LIGHT: {
                this.workspacePreferences.setTheme(Theme.light());
                break;
            }
            case DARK: {
                this.workspacePreferences.setTheme(Theme.dark());
                break;
            }
            case CUSTOM: {
                this.workspacePreferences.setTheme(Theme.custom(this.customPathToThemeProperty.getValue()));
            }
        }
        this.workspacePreferences.setThemeSyncOs(this.themeSyncOsProperty.getValue());
        this.workspacePreferences.setOpenLastEdited(this.openLastStartupProperty.getValue());
        this.workspacePreferences.setShowAdvancedHints(this.showAdvancedHintsProperty.getValue());
        this.workspacePreferences.setWarnAboutDuplicatesInInspection(this.inspectionWarningDuplicateProperty.getValue());
        this.workspacePreferences.setConfirmDelete(this.confirmDeleteProperty.getValue());
        this.libraryPreferences.setDefaultBibDatabaseMode((BibDatabaseMode)((Object)this.selectedBiblatexModeProperty.getValue()));
        this.libraryPreferences.setAlwaysReformatOnSave(this.alwaysReformatBibProperty.getValue());
        this.libraryPreferences.setAutoSave(this.autosaveLocalLibraries.getValue());
        this.filePreferences.createBackupProperty().setValue(this.createBackupProperty.getValue());
        this.filePreferences.backupDirectoryProperty().setValue((Object)Path.of(this.backupDirectoryProperty.getValue(), new String[0]));
        this.getPortAsInt(this.remotePortProperty.getValue()).ifPresent(newPort -> {
            if (this.remotePreferences.isDifferentPort((int)newPort)) {
                this.remotePreferences.setPort((int)newPort);
            }
        });
        this.internalPreferences.setVersionCheckEnabled(this.versionCheckProperty.getValue());
        this.getPortAsInt(this.remotePortProperty.getValue()).ifPresent(newPort -> {
            if (this.remotePreferences.isDifferentPort((int)newPort)) {
                this.remotePreferences.setPort((int)newPort);
            }
        });
        UiMessageHandler uiMessageHandler = (UiMessageHandler)Injector.instantiateModelOrService(UiMessageHandler.class);
        RemoteListenerServerManager remoteListenerServerManager = (RemoteListenerServerManager)Injector.instantiateModelOrService(RemoteListenerServerManager.class);
        remoteListenerServerManager.stop();
        if (this.remoteServerProperty.getValue().booleanValue()) {
            this.remotePreferences.setUseRemoteServer(true);
            remoteListenerServerManager.openAndStart(new CLIMessageHandler(uiMessageHandler, this.preferences, this.fileUpdateMonitor, this.entryTypesManager), this.remotePreferences.getPort());
        } else {
            this.remotePreferences.setUseRemoteServer(false);
        }
        this.trustStoreManager.flush();
        if (this.remoteServerProperty.getValue().booleanValue()) {
            this.remotePreferences.setUseRemoteServer(true);
            remoteListenerServerManager.openAndStart(new CLIMessageHandler(uiMessageHandler, this.preferences, this.fileUpdateMonitor, this.entryTypesManager), this.remotePreferences.getPort());
        } else {
            this.remotePreferences.setUseRemoteServer(false);
            remoteListenerServerManager.stop();
        }
        this.trustStoreManager.flush();
    }

    public ValidationStatus fontSizeValidationStatus() {
        return this.fontSizeValidator.getValidationStatus();
    }

    public ValidationStatus customPathToThemeValidationStatus() {
        return this.customPathToThemeValidator.getValidationStatus();
    }

    @Override
    public boolean validateSettings() {
        ValidationStatus validationStatus;
        CompositeValidator validator = new CompositeValidator();
        if (this.remoteServerProperty.getValue().booleanValue()) {
            validator.addValidators(new Validator[]{this.remotePortValidator});
        }
        if (this.fontOverrideProperty.getValue().booleanValue()) {
            validator.addValidators(new Validator[]{this.fontSizeValidator});
        }
        if (this.selectedThemeProperty.getValue() == ThemeTypes.CUSTOM) {
            validator.addValidators(new Validator[]{this.customPathToThemeValidator});
        }
        if (!(validationStatus = validator.getValidationStatus()).isValid()) {
            validationStatus.getHighestMessage().ifPresent(message -> this.dialogService.showErrorDialogAndWait(message.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    public List<String> getRestartWarnings() {
        return this.restartWarning;
    }

    public ReadOnlyListProperty<Language> languagesListProperty() {
        return this.languagesListProperty;
    }

    public ObjectProperty<Language> selectedLanguageProperty() {
        return this.selectedLanguageProperty;
    }

    public ReadOnlyListProperty<ThemeTypes> themesListProperty() {
        return this.themesListProperty;
    }

    public ObjectProperty<ThemeTypes> selectedThemeProperty() {
        return this.selectedThemeProperty;
    }

    public BooleanProperty themeSyncOsProperty() {
        return this.themeSyncOsProperty;
    }

    public StringProperty customPathToThemeProperty() {
        return this.customPathToThemeProperty;
    }

    public void importCSSFile() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.CSS).withDefaultExtension(StandardFileType.CSS).withInitialDirectory(this.preferences.getInternalPreferences().getLastPreferencesExportPath()).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(file -> this.customPathToThemeProperty.setValue(file.toAbsolutePath().toString()));
    }

    public BooleanProperty fontOverrideProperty() {
        return this.fontOverrideProperty;
    }

    public StringProperty fontSizeProperty() {
        return this.fontSizeProperty;
    }

    public BooleanProperty openLastStartupProperty() {
        return this.openLastStartupProperty;
    }

    public BooleanProperty showAdvancedHintsProperty() {
        return this.showAdvancedHintsProperty;
    }

    public BooleanProperty inspectionWarningDuplicateProperty() {
        return this.inspectionWarningDuplicateProperty;
    }

    public BooleanProperty confirmDeleteProperty() {
        return this.confirmDeleteProperty;
    }

    public ListProperty<BibDatabaseMode> biblatexModeListProperty() {
        return this.bibliographyModeListProperty;
    }

    public ObjectProperty<BibDatabaseMode> selectedBiblatexModeProperty() {
        return this.selectedBiblatexModeProperty;
    }

    public BooleanProperty alwaysReformatBibProperty() {
        return this.alwaysReformatBibProperty;
    }

    public BooleanProperty autosaveLocalLibrariesProperty() {
        return this.autosaveLocalLibraries;
    }

    public BooleanProperty createBackupProperty() {
        return this.createBackupProperty;
    }

    public StringProperty backupDirectoryProperty() {
        return this.backupDirectoryProperty;
    }

    public void backupFileDirBrowse() {
        DirectoryDialogConfiguration dirDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(Path.of(this.backupDirectoryProperty().getValue(), new String[0])).build();
        this.dialogService.showDirectorySelectionDialog(dirDialogConfiguration).ifPresent(dir -> this.backupDirectoryProperty.setValue(dir.toString()));
    }

    public BooleanProperty remoteServerProperty() {
        return this.remoteServerProperty;
    }

    public StringProperty remotePortProperty() {
        return this.remotePortProperty;
    }

    public void openBrowser() {
        String url = "https://themes.jabref.org";
        try {
            JabRefDesktop.openBrowser(url, this.preferences.getFilePreferences());
        }
        catch (IOException e) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Could not open website.", new Object[0]), e);
        }
    }

    private Optional<Integer> getPortAsInt(String value) {
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }
}

