/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.journals;

import java.util.Locale;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.logic.journals.Abbreviation;

public class AbbreviationViewModel {
    private final StringProperty name = new SimpleStringProperty("");
    private final StringProperty abbreviation = new SimpleStringProperty("");
    private final StringProperty shortestUniqueAbbreviation = new SimpleStringProperty("");
    private final BooleanProperty pseudoAbbreviation = new SimpleBooleanProperty();

    public AbbreviationViewModel(Abbreviation abbreviationObject) {
        this.pseudoAbbreviation.set(abbreviationObject == null);
        if (abbreviationObject != null) {
            this.name.setValue(abbreviationObject.getName());
            this.abbreviation.setValue(abbreviationObject.getAbbreviation());
            String shortestUniqueAbbreviationOfAbbreviation = abbreviationObject.getShortestUniqueAbbreviation();
            boolean shortestUniqueAbbreviationIsDefaultValue = shortestUniqueAbbreviationOfAbbreviation.equals(abbreviationObject.getAbbreviation());
            if (shortestUniqueAbbreviationIsDefaultValue) {
                this.shortestUniqueAbbreviation.set((Object)"");
            } else {
                this.shortestUniqueAbbreviation.setValue(shortestUniqueAbbreviationOfAbbreviation);
            }
        }
    }

    public Abbreviation getAbbreviationObject() {
        return new Abbreviation(this.getName(), this.getAbbreviation(), this.getShortestUniqueAbbreviation());
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public String getAbbreviation() {
        return (String)this.abbreviation.get();
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation.set((Object)abbreviation);
    }

    public String getShortestUniqueAbbreviation() {
        return (String)this.shortestUniqueAbbreviation.get();
    }

    public void setShortestUniqueAbbreviation(String shortestUniqueAbbreviation) {
        this.shortestUniqueAbbreviation.set((Object)shortestUniqueAbbreviation);
    }

    public boolean isPseudoAbbreviation() {
        return this.pseudoAbbreviation.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public StringProperty abbreviationProperty() {
        return this.abbreviation;
    }

    public StringProperty shortestUniqueAbbreviationProperty() {
        return this.shortestUniqueAbbreviation;
    }

    public BooleanProperty isPseudoAbbreviationProperty() {
        return this.pseudoAbbreviation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbbreviationViewModel that = (AbbreviationViewModel)o;
        return this.getName().equals(that.getName()) && this.getAbbreviation().equals(that.getAbbreviation()) && this.getShortestUniqueAbbreviation().equals(that.getShortestUniqueAbbreviation()) && this.isPseudoAbbreviation() == that.isPseudoAbbreviation();
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getAbbreviation(), this.getShortestUniqueAbbreviation(), this.isPseudoAbbreviation());
    }

    public boolean containsCaseIndependent(String searchTerm) {
        searchTerm = searchTerm.toLowerCase(Locale.ROOT);
        return ((String)this.abbreviation.get()).toLowerCase(Locale.ROOT).contains(searchTerm) || ((String)this.name.get()).toLowerCase(Locale.ROOT).contains(searchTerm) || ((String)this.shortestUniqueAbbreviation.get()).toLowerCase(Locale.ROOT).contains(searchTerm);
    }
}

