/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.linkedfiles;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.linkedfiles.LinkedFilesTabViewModel;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;

public class LinkedFilesTab
extends AbstractPreferenceTabView<LinkedFilesTabViewModel>
implements PreferencesTab {
    @FXML
    private TextField mainFileDirectory;
    @FXML
    private RadioButton useMainFileDirectory;
    @FXML
    private RadioButton useBibLocationAsPrimary;
    @FXML
    private Button browseDirectory;
    @FXML
    private Button autolinkRegexHelp;
    @FXML
    private RadioButton autolinkFileStartsBibtex;
    @FXML
    private RadioButton autolinkFileExactBibtex;
    @FXML
    private RadioButton autolinkUseRegex;
    @FXML
    private TextField autolinkRegexKey;
    @FXML
    private CheckBox fulltextIndex;
    @FXML
    private ComboBox<String> fileNamePattern;
    @FXML
    private TextField fileDirectoryPattern;
    @FXML
    private CheckBox confirmLinkedFileDelete;
    @FXML
    private CheckBox moveToTrash;
    private final ControlsFxVisualizer validationVisualizer = new ControlsFxVisualizer();

    public LinkedFilesTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Linked files", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new LinkedFilesTabViewModel(this.dialogService, this.preferencesService);
        this.mainFileDirectory.textProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).mainFileDirectoryProperty());
        this.mainFileDirectory.disableProperty().bind((ObservableValue)((LinkedFilesTabViewModel)this.viewModel).useBibLocationAsPrimaryProperty());
        this.browseDirectory.disableProperty().bind((ObservableValue)((LinkedFilesTabViewModel)this.viewModel).useBibLocationAsPrimaryProperty());
        this.useBibLocationAsPrimary.selectedProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).useBibLocationAsPrimaryProperty());
        this.useMainFileDirectory.selectedProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).useMainFileDirectoryProperty());
        this.moveToTrash.selectedProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).moveToTrashProperty());
        this.moveToTrash.setDisable(!JabRefDesktop.moveToTrashSupported());
        this.autolinkFileStartsBibtex.selectedProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).autolinkFileStartsBibtexProperty());
        this.autolinkFileExactBibtex.selectedProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).autolinkFileExactBibtexProperty());
        this.autolinkUseRegex.selectedProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).autolinkUseRegexProperty());
        this.autolinkRegexKey.textProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).autolinkRegexKeyProperty());
        this.autolinkRegexKey.disableProperty().bind((ObservableValue)this.autolinkUseRegex.selectedProperty().not());
        this.fulltextIndex.selectedProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).fulltextIndexProperty());
        this.fileNamePattern.valueProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).fileNamePatternProperty());
        this.fileNamePattern.itemsProperty().bind(((LinkedFilesTabViewModel)this.viewModel).defaultFileNamePatternsProperty());
        this.fileDirectoryPattern.textProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).fileDirectoryPatternProperty());
        this.confirmLinkedFileDelete.selectedProperty().bindBidirectional((Property)((LinkedFilesTabViewModel)this.viewModel).confirmLinkedFileDeleteProperty());
        ActionFactory actionFactory = new ActionFactory();
        actionFactory.configureIconButton(StandardActions.HELP_REGEX_SEARCH, (Command)new HelpAction(HelpFile.REGEX_SEARCH, this.dialogService, this.preferencesService.getFilePreferences()), (ButtonBase)this.autolinkRegexHelp);
        this.validationVisualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        Platform.runLater(() -> this.validationVisualizer.initVisualization(((LinkedFilesTabViewModel)this.viewModel).mainFileDirValidationStatus(), (Control)this.mainFileDirectory));
    }

    public void mainFileDirBrowse() {
        ((LinkedFilesTabViewModel)this.viewModel).mainFileDirBrowse();
    }
}

