/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.nameformatter;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.commands.Command;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.nameformatter.NameFormatterItemModel;
import org.jabref.gui.preferences.nameformatter.NameFormatterTabViewModel;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;

public class NameFormatterTab
extends AbstractPreferenceTabView<NameFormatterTabViewModel>
implements PreferencesTab {
    @FXML
    private TableView<NameFormatterItemModel> formatterList;
    @FXML
    private TableColumn<NameFormatterItemModel, String> formatterNameColumn;
    @FXML
    private TableColumn<NameFormatterItemModel, String> formatterStringColumn;
    @FXML
    private TableColumn<NameFormatterItemModel, String> actionsColumn;
    @FXML
    private TextField addFormatterName;
    @FXML
    private TextField addFormatterString;
    @FXML
    private Button formatterHelp;

    public NameFormatterTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Name formatter", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new NameFormatterTabViewModel(this.preferencesService.getNameFormatterPreferences());
        this.formatterNameColumn.setSortable(true);
        this.formatterNameColumn.setReorderable(false);
        this.formatterNameColumn.setCellValueFactory(cellData -> ((NameFormatterItemModel)cellData.getValue()).nameProperty());
        this.formatterNameColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.formatterNameColumn.setEditable(true);
        this.formatterNameColumn.setOnEditCommit(event -> ((NameFormatterItemModel)event.getRowValue()).setName((String)event.getNewValue()));
        this.formatterStringColumn.setSortable(true);
        this.formatterStringColumn.setReorderable(false);
        this.formatterStringColumn.setCellValueFactory(cellData -> ((NameFormatterItemModel)cellData.getValue()).formatProperty());
        this.formatterStringColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.formatterStringColumn.setEditable(true);
        this.formatterStringColumn.setOnEditCommit(event -> ((NameFormatterItemModel)event.getRowValue()).setFormat((String)event.getNewValue()));
        this.actionsColumn.setSortable(false);
        this.actionsColumn.setReorderable(false);
        this.actionsColumn.setCellValueFactory(cellData -> ((NameFormatterItemModel)cellData.getValue()).nameProperty());
        new ValueTableCellFactory().withGraphic(name -> IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode()).withTooltip(name -> Localization.lang("Remove formatter '%0'", name)).withOnMouseClickedEvent(item -> evt -> ((NameFormatterTabViewModel)this.viewModel).removeFormatter((NameFormatterItemModel)this.formatterList.getFocusModel().getFocusedItem())).install(this.actionsColumn);
        this.formatterList.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.DELETE) {
                ((NameFormatterTabViewModel)this.viewModel).removeFormatter((NameFormatterItemModel)this.formatterList.getSelectionModel().getSelectedItem());
                event.consume();
            }
        });
        this.formatterList.setEditable(true);
        this.formatterList.itemsProperty().bindBidirectional(((NameFormatterTabViewModel)this.viewModel).formatterListProperty());
        this.addFormatterName.textProperty().bindBidirectional((Property)((NameFormatterTabViewModel)this.viewModel).addFormatterNameProperty());
        this.addFormatterName.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addFormatterString.requestFocus();
                this.addFormatterString.selectAll();
                event.consume();
            }
        });
        this.addFormatterString.textProperty().bindBidirectional((Property)((NameFormatterTabViewModel)this.viewModel).addFormatterStringProperty());
        this.addFormatterString.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                ((NameFormatterTabViewModel)this.viewModel).addFormatter();
                this.addFormatterName.requestFocus();
                event.consume();
            }
        });
        ActionFactory actionFactory = new ActionFactory();
        actionFactory.configureIconButton(StandardActions.HELP_NAME_FORMATTER, (Command)new HelpAction(HelpFile.CUSTOM_EXPORTS_NAME_FORMATTER, this.dialogService, this.preferencesService.getFilePreferences()), (ButtonBase)this.formatterHelp);
    }

    public void addFormatter() {
        ((NameFormatterTabViewModel)this.viewModel).addFormatter();
    }
}

