/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.preview;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.ListProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.preview.PreviewTabViewModel;
import org.jabref.gui.preview.PreviewViewer;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.preview.PreviewLayout;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.TestEntry;
import org.jabref.model.database.BibDatabaseContext;

public class PreviewTab
extends AbstractPreferenceTabView<PreviewTabViewModel>
implements PreferencesTab {
    @FXML
    private CheckBox showAsTabCheckBox;
    @FXML
    private CheckBox showPreviewTooltipCheckBox;
    @FXML
    private ListView<PreviewLayout> availableListView;
    @FXML
    private ListView<PreviewLayout> chosenListView;
    @FXML
    private Button toRightButton;
    @FXML
    private Button toLeftButton;
    @FXML
    private Button sortUpButton;
    @FXML
    private Button sortDownButton;
    @FXML
    private Label readOnlyLabel;
    @FXML
    private Button resetDefaultButton;
    @FXML
    private Tab previewTab;
    @FXML
    private CodeArea editArea;
    @FXML
    private CustomTextField searchBox;
    @Inject
    private StateManager stateManager;
    @Inject
    private ThemeManager themeManager;
    private final ContextMenu contextMenu = new ContextMenu();
    private long lastKeyPressTime;
    private String listSearchTerm;
    private final ControlsFxVisualizer validationVisualizer = new ControlsFxVisualizer();

    public PreviewTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Entry preview", new Object[0]);
    }

    @FXML
    private void selectBstFile(ActionEvent event) {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.BST).withDefaultExtension(StandardFileType.BST).withInitialDirectory(this.preferencesService.getFilePreferences().getWorkingDirectory()).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(bstFile -> ((PreviewTabViewModel)this.viewModel).addBstStyle((Path)bstFile));
    }

    public void initialize() {
        this.viewModel = new PreviewTabViewModel(this.dialogService, this.preferencesService.getPreviewPreferences(), this.taskExecutor, this.stateManager);
        this.lastKeyPressTime = System.currentTimeMillis();
        this.showAsTabCheckBox.selectedProperty().bindBidirectional((Property)((PreviewTabViewModel)this.viewModel).showAsExtraTabProperty());
        this.showPreviewTooltipCheckBox.selectedProperty().bindBidirectional((Property)((PreviewTabViewModel)this.viewModel).showPreviewInEntryTableTooltip());
        this.searchBox.setPromptText(Localization.lang("Search", new Object[0]) + "...");
        this.searchBox.setLeft(IconTheme.JabRefIcons.SEARCH.getGraphicNode());
        ActionFactory factory = new ActionFactory();
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.CUT, (Command)new EditAction(StandardActions.CUT)), factory.createMenuItem(StandardActions.COPY, (Command)new EditAction(StandardActions.COPY)), factory.createMenuItem(StandardActions.PASTE, (Command)new EditAction(StandardActions.PASTE)), factory.createMenuItem(StandardActions.SELECT_ALL, (Command)new EditAction(StandardActions.SELECT_ALL))});
        this.contextMenu.getItems().forEach(item -> item.setGraphic(null));
        this.contextMenu.getStyleClass().add((Object)"context-menu");
        this.availableListView.setItems(((PreviewTabViewModel)this.viewModel).getFilteredAvailableLayouts());
        ((PreviewTabViewModel)this.viewModel).availableSelectionModelProperty().setValue((Object)this.availableListView.getSelectionModel());
        new ViewModelListCellFactory().withText(PreviewLayout::getDisplayName).install(this.availableListView);
        this.availableListView.setOnDragOver(this::dragOver);
        this.availableListView.setOnDragDetected(this::dragDetectedInAvailable);
        this.availableListView.setOnDragDropped(event -> this.dragDropped(((PreviewTabViewModel)this.viewModel).availableListProperty(), (DragEvent)event));
        this.availableListView.setOnKeyTyped(event -> this.jumpToSearchKey(this.availableListView, (KeyEvent)event));
        this.availableListView.setOnMouseClicked(this::mouseClickedAvailable);
        this.availableListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ((MultipleSelectionModel)this.availableListView.selectionModelProperty().getValue()).selectedItemProperty().addListener((observable, oldValue, newValue) -> ((PreviewTabViewModel)this.viewModel).setPreviewLayout((PreviewLayout)newValue));
        this.chosenListView.itemsProperty().bindBidirectional(((PreviewTabViewModel)this.viewModel).chosenListProperty());
        ((PreviewTabViewModel)this.viewModel).chosenSelectionModelProperty().setValue((Object)this.chosenListView.getSelectionModel());
        new ViewModelListCellFactory().withText(PreviewLayout::getDisplayName).setOnDragDropped(this::dragDroppedInChosenCell).install(this.chosenListView);
        this.chosenListView.setOnDragOver(this::dragOver);
        this.chosenListView.setOnDragDetected(this::dragDetectedInChosen);
        this.chosenListView.setOnDragDropped(event -> this.dragDropped(((PreviewTabViewModel)this.viewModel).chosenListProperty(), (DragEvent)event));
        this.chosenListView.setOnKeyTyped(event -> this.jumpToSearchKey(this.chosenListView, (KeyEvent)event));
        this.chosenListView.setOnMouseClicked(this::mouseClickedChosen);
        this.chosenListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ((MultipleSelectionModel)this.chosenListView.selectionModelProperty().getValue()).selectedItemProperty().addListener((observable, oldValue, newValue) -> ((PreviewTabViewModel)this.viewModel).setPreviewLayout((PreviewLayout)newValue));
        this.toRightButton.disableProperty().bind((ObservableValue)((MultipleSelectionModel)((PreviewTabViewModel)this.viewModel).availableSelectionModelProperty().getValue()).selectedItemProperty().isNull());
        this.toLeftButton.disableProperty().bind((ObservableValue)((MultipleSelectionModel)((PreviewTabViewModel)this.viewModel).chosenSelectionModelProperty().getValue()).selectedItemProperty().isNull());
        this.sortUpButton.disableProperty().bind((ObservableValue)((MultipleSelectionModel)((PreviewTabViewModel)this.viewModel).chosenSelectionModelProperty().getValue()).selectedItemProperty().isNull());
        this.sortDownButton.disableProperty().bind((ObservableValue)((MultipleSelectionModel)((PreviewTabViewModel)this.viewModel).chosenSelectionModelProperty().getValue()).selectedItemProperty().isNull());
        PreviewViewer previewViewer = new PreviewViewer(new BibDatabaseContext(), this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.taskExecutor);
        previewViewer.setEntry(TestEntry.getTestEntry());
        EasyBind.subscribe(((PreviewTabViewModel)this.viewModel).selectedLayoutProperty(), previewViewer::setLayout);
        previewViewer.visibleProperty().bind((ObservableValue)((MultipleSelectionModel)((PreviewTabViewModel)this.viewModel).chosenSelectionModelProperty().getValue()).selectedItemProperty().isNotNull().or((ObservableBooleanValue)((MultipleSelectionModel)((PreviewTabViewModel)this.viewModel).availableSelectionModelProperty().getValue()).selectedItemProperty().isNotNull()));
        this.previewTab.setContent((Node)previewViewer);
        this.editArea.clear();
        this.editArea.setParagraphGraphicFactory(LineNumberFactory.get((GenericStyledArea)this.editArea));
        this.editArea.setContextMenu(this.contextMenu);
        this.editArea.visibleProperty().bind((ObservableValue)((MultipleSelectionModel)((PreviewTabViewModel)this.viewModel).chosenSelectionModelProperty().getValue()).selectedItemProperty().isNotNull().or((ObservableBooleanValue)((MultipleSelectionModel)((PreviewTabViewModel)this.viewModel).availableSelectionModelProperty().getValue()).selectedItemProperty().isNotNull()));
        BindingsHelper.bindBidirectional(this.editArea.textProperty(), ((PreviewTabViewModel)this.viewModel).sourceTextProperty(), newSourceText -> this.editArea.replaceText(newSourceText), newEditText -> {
            ((PreviewTabViewModel)this.viewModel).sourceTextProperty().setValue(newEditText);
            ((PreviewTabViewModel)this.viewModel).refreshPreview();
        });
        this.editArea.textProperty().addListener((obs, oldValue, newValue) -> this.editArea.setStyleSpans(0, ((PreviewTabViewModel)this.viewModel).computeHighlighting((String)newValue)));
        this.editArea.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                ((PreviewTabViewModel)this.viewModel).refreshPreview();
            }
        });
        this.searchBox.textProperty().addListener((observable, previousText, searchTerm) -> ((PreviewTabViewModel)this.viewModel).setAvailableFilter((String)searchTerm));
        this.readOnlyLabel.visibleProperty().bind((ObservableValue)((PreviewTabViewModel)this.viewModel).selectedIsEditableProperty().not());
        this.resetDefaultButton.disableProperty().bind((ObservableValue)((PreviewTabViewModel)this.viewModel).selectedIsEditableProperty().not());
        ((MenuItem)this.contextMenu.getItems().getFirst()).disableProperty().bind((ObservableValue)((PreviewTabViewModel)this.viewModel).selectedIsEditableProperty().not());
        ((MenuItem)this.contextMenu.getItems().get(2)).disableProperty().bind((ObservableValue)((PreviewTabViewModel)this.viewModel).selectedIsEditableProperty().not());
        this.editArea.editableProperty().bind((ObservableValue)((PreviewTabViewModel)this.viewModel).selectedIsEditableProperty());
        this.validationVisualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        Platform.runLater(() -> this.validationVisualizer.initVisualization(((PreviewTabViewModel)this.viewModel).chosenListValidationStatus(), this.chosenListView));
    }

    private void jumpToSearchKey(ListView<PreviewLayout> list, KeyEvent keypressed) {
        if (keypressed.getCharacter() == null) {
            return;
        }
        this.listSearchTerm = System.currentTimeMillis() - this.lastKeyPressTime < 1000L ? this.listSearchTerm + keypressed.getCharacter().toLowerCase() : keypressed.getCharacter().toLowerCase();
        this.lastKeyPressTime = System.currentTimeMillis();
        list.getItems().stream().filter(item -> item.getDisplayName().toLowerCase().startsWith(this.listSearchTerm)).findFirst().ifPresent(arg_0 -> list.scrollTo(arg_0));
    }

    private void dragOver(DragEvent event) {
        ((PreviewTabViewModel)this.viewModel).dragOver(event);
    }

    private void dragDetectedInAvailable(MouseEvent event) {
        ArrayList<PreviewLayout> selectedLayouts = new ArrayList<PreviewLayout>((Collection<PreviewLayout>)((MultipleSelectionModel)((PreviewTabViewModel)this.viewModel).availableSelectionModelProperty().getValue()).getSelectedItems());
        if (!selectedLayouts.isEmpty()) {
            Dragboard dragboard = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            ((PreviewTabViewModel)this.viewModel).dragDetected(((PreviewTabViewModel)this.viewModel).availableListProperty(), ((PreviewTabViewModel)this.viewModel).availableSelectionModelProperty(), selectedLayouts, dragboard);
        }
        event.consume();
    }

    private void dragDetectedInChosen(MouseEvent event) {
        ArrayList<PreviewLayout> selectedLayouts = new ArrayList<PreviewLayout>((Collection<PreviewLayout>)((MultipleSelectionModel)((PreviewTabViewModel)this.viewModel).chosenSelectionModelProperty().getValue()).getSelectedItems());
        if (!selectedLayouts.isEmpty()) {
            Dragboard dragboard = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            ((PreviewTabViewModel)this.viewModel).dragDetected(((PreviewTabViewModel)this.viewModel).chosenListProperty(), ((PreviewTabViewModel)this.viewModel).chosenSelectionModelProperty(), selectedLayouts, dragboard);
        }
        event.consume();
    }

    private void dragDropped(ListProperty<PreviewLayout> targetList, DragEvent event) {
        boolean success = ((PreviewTabViewModel)this.viewModel).dragDropped(targetList, event.getDragboard());
        event.setDropCompleted(success);
        event.consume();
    }

    private void dragDroppedInChosenCell(PreviewLayout targetLayout, DragEvent event) {
        boolean success = ((PreviewTabViewModel)this.viewModel).dragDroppedInChosenCell(targetLayout, event.getDragboard());
        event.setDropCompleted(success);
        event.consume();
    }

    public void toRightButtonAction() {
        ((PreviewTabViewModel)this.viewModel).addToChosen();
    }

    public void toLeftButtonAction() {
        ((PreviewTabViewModel)this.viewModel).removeFromChosen();
    }

    public void sortUpButtonAction() {
        ((PreviewTabViewModel)this.viewModel).selectedInChosenUp();
    }

    public void sortDownButtonAction() {
        ((PreviewTabViewModel)this.viewModel).selectedInChosenDown();
    }

    public void resetDefaultButtonAction() {
        ((PreviewTabViewModel)this.viewModel).resetDefaultLayout();
    }

    private void mouseClickedAvailable(MouseEvent event) {
        if (event.getClickCount() == 2) {
            ((PreviewTabViewModel)this.viewModel).addToChosen();
            event.consume();
        }
    }

    private void mouseClickedChosen(MouseEvent event) {
        if (event.getClickCount() == 2) {
            ((PreviewTabViewModel)this.viewModel).removeFromChosen();
            event.consume();
        }
    }

    private class EditAction
    extends SimpleCommand {
        private final StandardActions command;

        public EditAction(StandardActions command) {
            this.command = command;
        }

        public void execute() {
            if (PreviewTab.this.editArea != null) {
                switch (this.command) {
                    case COPY: {
                        PreviewTab.this.editArea.copy();
                        break;
                    }
                    case CUT: {
                        PreviewTab.this.editArea.cut();
                        break;
                    }
                    case PASTE: {
                        PreviewTab.this.editArea.paste();
                        break;
                    }
                    case SELECT_ALL: {
                        PreviewTab.this.editArea.selectAll();
                    }
                }
                PreviewTab.this.editArea.requestFocus();
            }
        }
    }
}

