/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.protectedterms;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.jabref.gui.DialogService;
import org.jabref.gui.preferences.protectedterms.ProtectedTermsListItemModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.protectedterms.ProtectedTermsList;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.StandardFileType;
import org.jabref.preferences.FilePreferences;

public class NewProtectedTermsFileDialog
extends BaseDialog<Void> {
    private final TextField newFile = new TextField();
    private final DialogService dialogService;

    public NewProtectedTermsFileDialog(List<ProtectedTermsListItemModel> termsLists, DialogService dialogService, FilePreferences filePreferences) {
        this.dialogService = dialogService;
        this.setTitle(Localization.lang("New protected terms file", new Object[0]));
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(Localization.lang("Protected terms file", new Object[0]), (FileType)StandardFileType.TERMS).withDefaultExtension(Localization.lang("Protected terms file", new Object[0]), StandardFileType.TERMS).withInitialDirectory(filePreferences.getWorkingDirectory()).build();
        Button browse = new Button(Localization.lang("Browse", new Object[0]));
        browse.setOnAction(event -> this.dialogService.showFileSaveDialog(fileDialogConfiguration).ifPresent(file -> this.newFile.setText(file.toAbsolutePath().toString())));
        TextField newDescription = new TextField();
        VBox container = new VBox(10.0, new Node[]{new VBox(5.0, new Node[]{new Label(Localization.lang("Description", new Object[0])), newDescription}), new VBox(5.0, new Node[]{new Label(Localization.lang("File", new Object[0])), new HBox(10.0, new Node[]{this.newFile, browse})})});
        this.getDialogPane().setContent((Node)container);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                ProtectedTermsList newList = new ProtectedTermsList(newDescription.getText(), new ArrayList<String>(), this.newFile.getText(), false);
                newList.setEnabled(true);
                newList.createAndWriteHeading(newDescription.getText());
                termsLists.add(new ProtectedTermsListItemModel(newList));
            }
            return null;
        });
    }
}

