/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.protectedterms;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import org.jabref.logic.protectedterms.ProtectedTermsList;

public class ProtectedTermsListItemModel {
    private final ProtectedTermsList termsList;
    private final BooleanProperty enabledProperty = new SimpleBooleanProperty();

    public ProtectedTermsListItemModel(ProtectedTermsList termsList) {
        this.termsList = termsList;
        this.enabledProperty.setValue(Boolean.valueOf(termsList.isEnabled()));
    }

    public ProtectedTermsList getTermsList() {
        this.termsList.setEnabled(this.enabledProperty.getValue());
        return this.termsList;
    }

    public ReadOnlyStringProperty descriptionProperty() {
        return new ReadOnlyStringWrapper(this.termsList.getDescription());
    }

    public ReadOnlyStringProperty locationProperty() {
        return new ReadOnlyStringWrapper(this.termsList.getLocation());
    }

    public ReadOnlyBooleanProperty internalProperty() {
        return new ReadOnlyBooleanWrapper(this.termsList.isInternalList());
    }

    public BooleanProperty enabledProperty() {
        return this.enabledProperty;
    }
}

