/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.protectedterms;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.commands.Command;
import jakarta.inject.Inject;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.fxml.FXML;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.protectedterms.ProtectedTermsListItemModel;
import org.jabref.gui.preferences.protectedterms.ProtectedTermsTabViewModel;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.gui.util.ViewModelTableRowFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.protectedterms.ProtectedTermsList;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;

public class ProtectedTermsTab
extends AbstractPreferenceTabView<ProtectedTermsTabViewModel>
implements PreferencesTab {
    @FXML
    private TableView<ProtectedTermsListItemModel> filesTable;
    @FXML
    private TableColumn<ProtectedTermsListItemModel, Boolean> filesTableEnabledColumn;
    @FXML
    private TableColumn<ProtectedTermsListItemModel, String> filesTableDescriptionColumn;
    @FXML
    private TableColumn<ProtectedTermsListItemModel, String> filesTableFileColumn;
    @FXML
    private TableColumn<ProtectedTermsListItemModel, Boolean> filesTableEditColumn;
    @FXML
    private TableColumn<ProtectedTermsListItemModel, Boolean> filesTableDeleteColumn;
    @Inject
    private ProtectedTermsLoader termsLoader;

    public ProtectedTermsTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Protected terms files", new Object[0]);
    }

    @FXML
    public void initialize() {
        this.viewModel = new ProtectedTermsTabViewModel(this.termsLoader, this.dialogService, this.preferencesService);
        new ViewModelTableRowFactory<ProtectedTermsListItemModel>().withContextMenu(this::createContextMenu).install(this.filesTable);
        this.filesTableEnabledColumn.setCellFactory(CheckBoxTableCell.forTableColumn(this.filesTableEnabledColumn));
        this.filesTableEnabledColumn.setCellValueFactory(data -> ((ProtectedTermsListItemModel)data.getValue()).enabledProperty());
        this.filesTableDescriptionColumn.setCellValueFactory(data -> BindingsHelper.constantOf(((ProtectedTermsListItemModel)data.getValue()).getTermsList().getDescription()));
        this.filesTableFileColumn.setCellValueFactory(data -> {
            ProtectedTermsList list = ((ProtectedTermsListItemModel)data.getValue()).getTermsList();
            if (list.isInternalList()) {
                return BindingsHelper.constantOf(Localization.lang("Internal list", new Object[0]));
            }
            return BindingsHelper.constantOf(list.getLocation());
        });
        this.filesTableEditColumn.setCellValueFactory(data -> ((ProtectedTermsListItemModel)data.getValue()).internalProperty().not());
        new ValueTableCellFactory().withGraphic(none -> IconTheme.JabRefIcons.EDIT.getGraphicNode()).withVisibleExpression(ReadOnlyBooleanWrapper::new).withOnMouseClickedEvent((item, none) -> event -> ((ProtectedTermsTabViewModel)this.viewModel).edit((ProtectedTermsListItemModel)item)).install(this.filesTableEditColumn);
        this.filesTableDeleteColumn.setCellValueFactory(data -> ((ProtectedTermsListItemModel)data.getValue()).internalProperty().not());
        new ValueTableCellFactory().withGraphic(none -> IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode()).withVisibleExpression(ReadOnlyBooleanWrapper::new).withTooltip(none -> Localization.lang("Remove protected terms file", new Object[0])).withOnMouseClickedEvent((item, none) -> event -> ((ProtectedTermsTabViewModel)this.viewModel).removeList((ProtectedTermsListItemModel)item)).install(this.filesTableDeleteColumn);
        this.filesTable.itemsProperty().set(((ProtectedTermsTabViewModel)this.viewModel).termsFilesProperty());
    }

    private ContextMenu createContextMenu(ProtectedTermsListItemModel file) {
        ActionFactory factory = new ActionFactory();
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.EDIT_LIST, (Command)new ContextAction(StandardActions.EDIT_LIST, file)), factory.createMenuItem(StandardActions.VIEW_LIST, (Command)new ContextAction(StandardActions.VIEW_LIST, file)), factory.createMenuItem(StandardActions.REMOVE_LIST, (Command)new ContextAction(StandardActions.REMOVE_LIST, file)), factory.createMenuItem(StandardActions.RELOAD_LIST, (Command)new ContextAction(StandardActions.RELOAD_LIST, file))});
        contextMenu.getItems().forEach(item -> item.setGraphic(null));
        contextMenu.getStyleClass().add((Object)"context-menu");
        return contextMenu;
    }

    @FXML
    private void addFile() {
        ((ProtectedTermsTabViewModel)this.viewModel).addFile();
    }

    @FXML
    private void createNewFile() {
        ((ProtectedTermsTabViewModel)this.viewModel).createNewFile();
    }

    private class ContextAction
    extends SimpleCommand {
        private final StandardActions command;
        private final ProtectedTermsListItemModel itemModel;

        public ContextAction(StandardActions command, ProtectedTermsListItemModel itemModel) {
            this.command = command;
            this.itemModel = itemModel;
            this.executable.bind(BindingsHelper.constantOf(switch (command) {
                case StandardActions.EDIT_LIST, StandardActions.REMOVE_LIST, StandardActions.RELOAD_LIST -> {
                    if (!itemModel.getTermsList().isInternalList()) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            }));
        }

        public void execute() {
            switch (this.command) {
                case EDIT_LIST: {
                    ((ProtectedTermsTabViewModel)ProtectedTermsTab.this.viewModel).edit(this.itemModel);
                    break;
                }
                case VIEW_LIST: {
                    ((ProtectedTermsTabViewModel)ProtectedTermsTab.this.viewModel).displayContent(this.itemModel);
                    break;
                }
                case REMOVE_LIST: {
                    ((ProtectedTermsTabViewModel)ProtectedTermsTab.this.viewModel).removeList(this.itemModel);
                    break;
                }
                case RELOAD_LIST: {
                    ((ProtectedTermsTabViewModel)ProtectedTermsTab.this.viewModel).reloadList(this.itemModel);
                }
            }
        }
    }
}

