/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.websearch;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import kong.unirest.core.UnirestException;
import org.jabref.gui.DialogService;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.slr.StudyCatalogItem;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ImporterPreferences;
import org.jabref.logic.importer.WebFetcher;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.importer.fetcher.CustomizableKeyFetcher;
import org.jabref.logic.importer.fetcher.GrobidPreferences;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.net.URLDownload;
import org.jabref.logic.preferences.DOIPreferences;
import org.jabref.logic.preferences.FetcherApiKey;
import org.jabref.logic.util.OS;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.PreferencesService;

public class WebSearchTabViewModel
implements PreferenceTabViewModel {
    private final BooleanProperty enableWebSearchProperty = new SimpleBooleanProperty();
    private final BooleanProperty generateKeyOnImportProperty = new SimpleBooleanProperty();
    private final BooleanProperty warnAboutDuplicatesOnImportProperty = new SimpleBooleanProperty();
    private final BooleanProperty shouldDownloadLinkedOnlineFiles = new SimpleBooleanProperty();
    private final BooleanProperty useCustomDOIProperty = new SimpleBooleanProperty();
    private final StringProperty useCustomDOINameProperty = new SimpleStringProperty("");
    private final ObservableList<StudyCatalogItem> catalogs = FXCollections.observableArrayList();
    private final BooleanProperty grobidEnabledProperty = new SimpleBooleanProperty();
    private final StringProperty grobidURLProperty = new SimpleStringProperty("");
    private final ListProperty<FetcherApiKey> apiKeys = new SimpleListProperty();
    private final ObjectProperty<FetcherApiKey> selectedApiKeyProperty = new SimpleObjectProperty();
    private final BooleanProperty apikeyPersistProperty = new SimpleBooleanProperty();
    private final BooleanProperty apikeyPersistAvailableProperty = new SimpleBooleanProperty();
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final DOIPreferences doiPreferences;
    private final GrobidPreferences grobidPreferences;
    private final ImporterPreferences importerPreferences;
    private final FilePreferences filePreferences;
    private final ImportFormatPreferences importFormatPreferences;

    public WebSearchTabViewModel(PreferencesService preferencesService, DialogService dialogService) {
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.importerPreferences = preferencesService.getImporterPreferences();
        this.grobidPreferences = preferencesService.getGrobidPreferences();
        this.doiPreferences = preferencesService.getDOIPreferences();
        this.filePreferences = preferencesService.getFilePreferences();
        this.importFormatPreferences = preferencesService.getImportFormatPreferences();
    }

    @Override
    public void setValues() {
        this.enableWebSearchProperty.setValue(Boolean.valueOf(this.importerPreferences.areImporterEnabled()));
        this.generateKeyOnImportProperty.setValue(Boolean.valueOf(this.importerPreferences.isGenerateNewKeyOnImport()));
        this.warnAboutDuplicatesOnImportProperty.setValue(Boolean.valueOf(this.importerPreferences.shouldWarnAboutDuplicatesOnImport()));
        this.shouldDownloadLinkedOnlineFiles.setValue(Boolean.valueOf(this.filePreferences.shouldDownloadLinkedFiles()));
        this.useCustomDOIProperty.setValue(Boolean.valueOf(this.doiPreferences.isUseCustom()));
        this.useCustomDOINameProperty.setValue(this.doiPreferences.getDefaultBaseURI());
        this.grobidEnabledProperty.setValue(Boolean.valueOf(this.grobidPreferences.isGrobidEnabled()));
        this.grobidURLProperty.setValue(this.grobidPreferences.getGrobidURL());
        this.apiKeys.setValue(FXCollections.observableArrayList(this.preferencesService.getImporterPreferences().getApiKeys()));
        this.apikeyPersistAvailableProperty.setValue(Boolean.valueOf(OS.isKeyringAvailable()));
        this.apikeyPersistProperty.setValue(Boolean.valueOf(this.preferencesService.getImporterPreferences().shouldPersistCustomKeys()));
        this.catalogs.addAll(WebFetchers.getSearchBasedFetchers(this.importFormatPreferences, this.importerPreferences).stream().map(WebFetcher::getName).filter(name -> !name.equals("Search Selected")).map(name -> {
            boolean enabled = this.importerPreferences.getCatalogs().contains(name);
            return new StudyCatalogItem((String)name, enabled);
        }).toList());
    }

    @Override
    public void storeSettings() {
        this.importerPreferences.setImporterEnabled(this.enableWebSearchProperty.getValue());
        this.importerPreferences.setGenerateNewKeyOnImport(this.generateKeyOnImportProperty.getValue());
        this.importerPreferences.setWarnAboutDuplicatesOnImport(this.warnAboutDuplicatesOnImportProperty.getValue());
        this.filePreferences.setDownloadLinkedFiles(this.shouldDownloadLinkedOnlineFiles.getValue());
        this.grobidPreferences.setGrobidEnabled(this.grobidEnabledProperty.getValue());
        this.grobidPreferences.setGrobidOptOut(this.grobidPreferences.isGrobidOptOut());
        this.grobidPreferences.setGrobidURL(this.grobidURLProperty.getValue());
        this.doiPreferences.setUseCustom(this.useCustomDOIProperty.get());
        this.doiPreferences.setDefaultBaseURI(this.useCustomDOINameProperty.getValue().trim());
        this.importerPreferences.setCatalogs((List<String>)FXCollections.observableList(this.catalogs.stream().filter(StudyCatalogItem::isEnabled).map(StudyCatalogItem::getName).collect(Collectors.toList())));
        this.importerPreferences.setPersistCustomKeys(this.apikeyPersistProperty.get());
        this.preferencesService.getImporterPreferences().getApiKeys().clear();
        if (this.apikeyPersistAvailableProperty.get()) {
            this.preferencesService.getImporterPreferences().getApiKeys().addAll(this.apiKeys);
        }
    }

    public BooleanProperty enableWebSearchProperty() {
        return this.enableWebSearchProperty;
    }

    public BooleanProperty generateKeyOnImportProperty() {
        return this.generateKeyOnImportProperty;
    }

    public BooleanProperty useCustomDOIProperty() {
        return this.useCustomDOIProperty;
    }

    public StringProperty useCustomDOINameProperty() {
        return this.useCustomDOINameProperty;
    }

    public ObservableList<StudyCatalogItem> getCatalogs() {
        return this.catalogs;
    }

    public BooleanProperty grobidEnabledProperty() {
        return this.grobidEnabledProperty;
    }

    public StringProperty grobidURLProperty() {
        return this.grobidURLProperty;
    }

    public ListProperty<FetcherApiKey> fetcherApiKeys() {
        return this.apiKeys;
    }

    public ObjectProperty<FetcherApiKey> selectedApiKeyProperty() {
        return this.selectedApiKeyProperty;
    }

    public BooleanProperty warnAboutDuplicatesOnImportProperty() {
        return this.warnAboutDuplicatesOnImportProperty;
    }

    public BooleanProperty shouldDownloadLinkedOnlineFiles() {
        return this.shouldDownloadLinkedOnlineFiles;
    }

    public ReadOnlyBooleanProperty apiKeyPersistAvailable() {
        return this.apikeyPersistAvailableProperty;
    }

    public BooleanProperty getApikeyPersistProperty() {
        return this.apikeyPersistProperty;
    }

    public void checkCustomApiKey() {
        boolean keyValid;
        String apiKeyName = ((FetcherApiKey)this.selectedApiKeyProperty.get()).getName();
        Optional<CustomizableKeyFetcher> fetcherOpt = WebFetchers.getCustomizableKeyFetchers(this.preferencesService.getImportFormatPreferences(), this.preferencesService.getImporterPreferences()).stream().filter(fetcher -> fetcher.getName().equals(apiKeyName)).findFirst();
        if (fetcherOpt.isEmpty()) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Check %0 API Key Setting", apiKeyName), Localization.lang("Fetcher unknown!", new Object[0]));
            return;
        }
        String testUrlWithoutApiKey = fetcherOpt.get().getTestUrl();
        if (testUrlWithoutApiKey == null) {
            this.dialogService.showWarningDialogAndWait(Localization.lang("Check %0 API Key Setting", apiKeyName), Localization.lang("Fetcher cannot be tested!", new Object[0]));
            return;
        }
        String apiKey = ((FetcherApiKey)this.selectedApiKeyProperty.get()).getKey();
        if (!apiKey.isEmpty()) {
            try {
                SSLSocketFactory defaultSslSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
                HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                URLDownload urlDownload = new URLDownload(testUrlWithoutApiKey + apiKey);
                int statusCode = ((HttpURLConnection)urlDownload.getSource().openConnection()).getResponseCode();
                keyValid = statusCode >= 200 && statusCode < 300;
                URLDownload.setSSLVerification(defaultSslSocketFactory, defaultHostnameVerifier);
            }
            catch (IOException | UnirestException e) {
                keyValid = false;
            }
        } else {
            keyValid = false;
        }
        if (keyValid) {
            this.dialogService.showInformationDialogAndWait(Localization.lang("Check %0 API Key Setting", apiKeyName), Localization.lang("Connection successful!", new Object[0]));
        } else {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Check %0 API Key Setting", apiKeyName), Localization.lang("Connection failed!", new Object[0]));
        }
    }

    @Override
    public boolean validateSettings() {
        return this.getCatalogs().stream().anyMatch(StudyCatalogItem::isEnabled);
    }
}

