/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.jabref.gui.DialogService;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.push.AbstractPushToApplication;
import org.jabref.gui.push.PushToApplication;
import org.jabref.gui.push.PushToApplicationSettings;
import org.jabref.gui.push.PushToVimSettings;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.PushToApplicationPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushToVim
extends AbstractPushToApplication {
    public static final String NAME = "Vim";
    private static final Logger LOGGER = LoggerFactory.getLogger(PushToVim.class);

    public PushToVim(DialogService dialogService, PreferencesService preferencesService) {
        super(dialogService, preferencesService);
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    @Override
    public JabRefIcon getApplicationIcon() {
        return IconTheme.JabRefIcons.APPLICATION_VIM;
    }

    @Override
    public PushToApplicationSettings getSettings(PushToApplication application, PushToApplicationPreferences preferences) {
        return new PushToVimSettings(application, this.dialogService, this.preferencesService.getFilePreferences(), preferences);
    }

    @Override
    public void pushEntries(BibDatabaseContext database, List<BibEntry> entries, String keys) {
        this.couldNotPush = false;
        this.couldNotCall = false;
        this.notDefined = false;
        this.commandPath = (String)this.preferencesService.getPushToApplicationPreferences().getCommandPaths().get((Object)this.getDisplayName());
        if (this.commandPath == null || this.commandPath.trim().isEmpty()) {
            this.notDefined = true;
            return;
        }
        try {
            String[] com = new String[]{this.commandPath, "--servername", this.preferencesService.getPushToApplicationPreferences().getVimServer(), "--remote-send", "<C-\\><C-N>a" + this.getCitePrefix() + keys + this.getCiteSuffix()};
            LOGGER.atDebug().setMessage("Executing command {}").addArgument(() -> Arrays.toString(com)).log();
            Process p = Runtime.getRuntime().exec(com);
            HeadlessExecutorService.INSTANCE.executeAndWait(() -> {
                try (InputStream out = p.getErrorStream();){
                    StringBuilder sb = new StringBuilder();
                    try {
                        int c;
                        while ((c = out.read()) != -1) {
                            sb.append((char)c);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("Could not read from stderr.", (Throwable)e);
                    }
                    if (!sb.toString().trim().isEmpty()) {
                        LOGGER.warn("Push to Vim error: {}", (Object)sb);
                        this.couldNotPush = true;
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Error handling std streams", (Throwable)e);
                }
            });
        }
        catch (IOException excep) {
            LOGGER.warn("Problem pushing to Vim.", (Throwable)excep);
            this.couldNotCall = true;
        }
    }

    @Override
    public void onOperationCompleted() {
        if (this.couldNotPush) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error pushing entries", new Object[0]), Localization.lang("Could not push to a running Vim server.", new Object[0]));
        } else if (this.couldNotCall) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error pushing entries", new Object[0]), Localization.lang("Could not run the 'vim' program.", new Object[0]));
        } else {
            super.onOperationCompleted();
        }
    }
}

