/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.columns.SpecialFieldColumn;
import org.jabref.gui.preview.PreviewViewer;
import org.jabref.gui.search.GlobalSearchBar;
import org.jabref.gui.search.GlobalSearchResultDialogViewModel;
import org.jabref.gui.search.SearchResultsTable;
import org.jabref.gui.search.SearchResultsTableDataModel;
import org.jabref.gui.search.SearchType;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.PreferencesService;

public class GlobalSearchResultDialog
extends BaseDialog<Void> {
    @FXML
    private SplitPane container;
    @FXML
    private ToggleButton keepOnTop;
    @FXML
    private HBox searchBarContainer;
    private final UndoManager undoManager;
    private final LibraryTabContainer libraryTabContainer;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private StateManager stateManager;
    @Inject
    private DialogService dialogService;
    @Inject
    private ThemeManager themeManager;
    @Inject
    private TaskExecutor taskExecutor;
    private GlobalSearchResultDialogViewModel viewModel;

    public GlobalSearchResultDialog(UndoManager undoManager, LibraryTabContainer libraryTabContainer) {
        this.undoManager = undoManager;
        this.libraryTabContainer = libraryTabContainer;
        this.setTitle(Localization.lang("Search results from open libraries", new Object[0]));
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.initModality(Modality.NONE);
    }

    @FXML
    private void initialize() {
        this.viewModel = new GlobalSearchResultDialogViewModel(this.preferencesService);
        GlobalSearchBar searchBar = new GlobalSearchBar(this.libraryTabContainer, this.stateManager, this.preferencesService, this.undoManager, this.dialogService, SearchType.GLOBAL_SEARCH);
        this.searchBarContainer.getChildren().addFirst((Object)searchBar);
        HBox.setHgrow((Node)searchBar, (Priority)Priority.ALWAYS);
        PreviewViewer previewViewer = new PreviewViewer(this.viewModel.getSearchDatabaseContext(), this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.taskExecutor);
        previewViewer.setLayout(this.preferencesService.getPreviewPreferences().getSelectedPreviewLayout());
        SearchResultsTableDataModel model = new SearchResultsTableDataModel(this.viewModel.getSearchDatabaseContext(), this.preferencesService, this.stateManager);
        SearchResultsTable resultsTable = new SearchResultsTable(model, this.viewModel.getSearchDatabaseContext(), this.preferencesService, this.undoManager, this.dialogService, this.stateManager, this.taskExecutor);
        resultsTable.getColumns().removeIf(SpecialFieldColumn.class::isInstance);
        resultsTable.getSelectionModel().selectedItemProperty().addListener((obs, oldValue, newValue) -> {
            if (newValue != null) {
                previewViewer.setEntry(newValue.getEntry());
            } else {
                previewViewer.setEntry(oldValue.getEntry());
            }
        });
        Stage stage = (Stage)this.getDialogPane().getScene().getWindow();
        resultsTable.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                BibEntryTableViewModel selectedEntry = (BibEntryTableViewModel)resultsTable.getSelectionModel().getSelectedItem();
                this.libraryTabContainer.getLibraryTabs().stream().filter(tab -> tab.getBibDatabaseContext().equals(selectedEntry.getBibDatabaseContext())).findFirst().ifPresent(this.libraryTabContainer::showLibraryTab);
                this.stateManager.clearSearchQuery();
                ((Optional)this.stateManager.activeTabProperty().get()).ifPresent(tab -> tab.clearAndSelect(selectedEntry.getEntry()));
                stage.close();
            }
        });
        this.container.getItems().addAll((Object[])new Node[]{resultsTable, previewViewer});
        this.keepOnTop.selectedProperty().bindBidirectional((Property)this.viewModel.keepOnTop());
        EasyBind.subscribe((ObservableValue)this.viewModel.keepOnTop(), value -> {
            stage.setAlwaysOnTop(value.booleanValue());
            this.keepOnTop.setGraphic(value != false ? IconTheme.JabRefIcons.KEEP_ON_TOP.getGraphicNode() : IconTheme.JabRefIcons.KEEP_ON_TOP_OFF.getGraphicNode());
        });
        stage.setOnShown(event -> {
            stage.setHeight(this.preferencesService.getSearchPreferences().getSearchWindowHeight());
            stage.setWidth(this.preferencesService.getSearchPreferences().getSearchWindowWidth());
        });
        stage.setOnHidden(event -> {
            this.preferencesService.getSearchPreferences().setSearchWindowHeight(this.getHeight());
            this.preferencesService.getSearchPreferences().setSearchWindowWidth(this.getWidth());
        });
    }
}

