/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search;

import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.MainTable;
import org.jabref.gui.maintable.MainTableColumnFactory;
import org.jabref.gui.maintable.MainTablePreferences;
import org.jabref.gui.maintable.PersistenceVisualStateTable;
import org.jabref.gui.maintable.SmartConstrainedResizePolicy;
import org.jabref.gui.maintable.columns.LibraryColumn;
import org.jabref.gui.maintable.columns.MainTableColumn;
import org.jabref.gui.search.SearchResultsTableDataModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.PreferencesService;

public class SearchResultsTable
extends TableView<BibEntryTableViewModel> {
    public SearchResultsTable(SearchResultsTableDataModel model, BibDatabaseContext database, PreferencesService preferencesService, UndoManager undoManager, DialogService dialogService, StateManager stateManager, TaskExecutor taskExecutor) {
        MainTablePreferences mainTablePreferences = preferencesService.getMainTablePreferences();
        List<TableColumn<BibEntryTableViewModel, ?>> allCols = new MainTableColumnFactory(database, preferencesService, preferencesService.getSearchDialogColumnPreferences(), undoManager, dialogService, stateManager, taskExecutor).createColumns();
        if (allCols.stream().noneMatch(LibraryColumn.class::isInstance)) {
            allCols.addFirst(new LibraryColumn());
        }
        this.getColumns().addAll(allCols);
        this.getSortOrder().clear();
        preferencesService.getSearchDialogColumnPreferences().getColumnSortOrder().forEach(columnModel -> this.getColumns().stream().map(column -> (MainTableColumn)((Object)((Object)column))).filter(column -> column.getModel().equals(columnModel)).findFirst().ifPresent(column -> this.getSortOrder().add((Object)column)));
        if (mainTablePreferences.getResizeColumnsToFit()) {
            this.setColumnResizePolicy(new SmartConstrainedResizePolicy());
        }
        this.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.setItems((ObservableList)model.getEntriesFilteredAndSorted());
        model.getEntriesFilteredAndSorted().comparatorProperty().bind((ObservableValue)this.comparatorProperty());
        this.getStylesheets().add((Object)MainTable.class.getResource("MainTable.css").toExternalForm());
        new PersistenceVisualStateTable(this, preferencesService.getSearchDialogColumnPreferences()).addListeners();
        database.getDatabase().registerListener((Object)this);
    }
}

