/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyObservableList;
import java.util.Collection;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import org.jabref.gui.StateManager;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.MainTableFieldValueFormatter;
import org.jabref.gui.maintable.NameDisplayPreferences;
import org.jabref.logic.search.SearchQuery;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;

public class SearchResultsTableDataModel {
    private final SortedList<BibEntryTableViewModel> entriesSorted;
    private final ObjectProperty<MainTableFieldValueFormatter> fieldValueFormatter;
    private final NameDisplayPreferences nameDisplayPreferences;
    private final BibDatabaseContext bibDatabaseContext;
    private final StateManager stateManager;

    public SearchResultsTableDataModel(BibDatabaseContext bibDatabaseContext, PreferencesService preferencesService, StateManager stateManager) {
        this.nameDisplayPreferences = preferencesService.getNameDisplayPreferences();
        this.bibDatabaseContext = bibDatabaseContext;
        this.stateManager = stateManager;
        this.fieldValueFormatter = new SimpleObjectProperty((Object)new MainTableFieldValueFormatter(this.nameDisplayPreferences, bibDatabaseContext));
        ObservableList entriesViewModel = FXCollections.observableArrayList();
        this.populateEntriesViewModel((ObservableList<BibEntryTableViewModel>)entriesViewModel);
        stateManager.getOpenDatabases().addListener(change -> this.populateEntriesViewModel((ObservableList<BibEntryTableViewModel>)entriesViewModel));
        FilteredList entriesFiltered = new FilteredList(entriesViewModel);
        entriesFiltered.predicateProperty().bind((ObservableValue)EasyBind.map(stateManager.activeGlobalSearchQueryProperty(), query -> entry -> this.isMatchedBySearch((Optional<SearchQuery>)query, (BibEntryTableViewModel)entry)));
        stateManager.getGlobalSearchResultSize().bind((ObservableValue)Bindings.size((ObservableList)entriesFiltered));
        this.entriesSorted = new SortedList((ObservableList)entriesFiltered);
    }

    private void populateEntriesViewModel(ObservableList<BibEntryTableViewModel> entriesViewModel) {
        entriesViewModel.clear();
        for (BibDatabaseContext context : this.stateManager.getOpenDatabases()) {
            ObservableList<BibEntry> entriesForDb = context.getDatabase().getEntries();
            EasyObservableList viewModelForDb = EasyBind.mapBacked(entriesForDb, entry -> new BibEntryTableViewModel((BibEntry)entry, context, (ObservableValue<MainTableFieldValueFormatter>)this.fieldValueFormatter));
            entriesViewModel.addAll((Collection)viewModelForDb);
        }
    }

    private boolean isMatchedBySearch(Optional<SearchQuery> query, BibEntryTableViewModel entry) {
        return query.map(matcher -> matcher.isMatch(entry.getEntry())).orElse(true);
    }

    public SortedList<BibEntryTableViewModel> getEntriesFilteredAndSorted() {
        return this.entriesSorted;
    }

    public void refresh() {
        this.fieldValueFormatter.setValue((Object)new MainTableFieldValueFormatter(this.nameDisplayPreferences, this.bibDatabaseContext));
    }
}

