/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search;

import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.control.textfield.TextFields;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.logic.l10n.Localization;

public class SearchTextField {
    public static CustomTextField create(KeyBindingRepository keyBindingRepository) {
        CustomTextField textField = (CustomTextField)TextFields.createClearableTextField();
        textField.setPromptText(Localization.lang("Search...", new Object[0]));
        textField.setId("searchField");
        textField.getStyleClass().add((Object)"search-field");
        Node graphicNode = IconTheme.JabRefIcons.SEARCH.getGraphicNode();
        graphicNode.getStyleClass().add((Object)"search-field-icon");
        textField.setLeft(graphicNode);
        textField.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (keyBindingRepository.matches((KeyEvent)event, KeyBinding.CLEAR_SEARCH)) {
                textField.clear();
                event.consume();
            }
        });
        return textField;
    }
}

