/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.sidepane;

import com.tobiasdiez.easybind.EasyBind;
import javafx.scene.control.Button;
import org.jabref.gui.DialogService;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.groups.GroupModeViewModel;
import org.jabref.gui.groups.GroupViewMode;
import org.jabref.gui.groups.GroupsPreferences;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.sidepane.SidePaneComponent;
import org.jabref.gui.sidepane.SidePaneContentFactory;
import org.jabref.gui.sidepane.SidePaneType;
import org.jabref.logic.l10n.Localization;

public class GroupsSidePaneComponent
extends SidePaneComponent {
    private final GroupsPreferences groupsPreferences;
    private final DialogService dialogService;
    private final Button intersectionUnionToggle = IconTheme.JabRefIcons.GROUP_INTERSECTION.asButton();

    public GroupsSidePaneComponent(SimpleCommand closeCommand, SimpleCommand moveUpCommand, SimpleCommand moveDownCommand, SidePaneContentFactory contentFactory, GroupsPreferences groupsPreferences, DialogService dialogService) {
        super(SidePaneType.GROUPS, closeCommand, moveUpCommand, moveDownCommand, contentFactory);
        this.groupsPreferences = groupsPreferences;
        this.dialogService = dialogService;
        this.setupIntersectionUnionToggle();
        EasyBind.subscribe(groupsPreferences.groupViewModeProperty(), mode -> {
            GroupModeViewModel modeViewModel = new GroupModeViewModel((GroupViewMode)((Object)mode));
            this.intersectionUnionToggle.setGraphic(modeViewModel.getUnionIntersectionGraphic());
            this.intersectionUnionToggle.setTooltip(modeViewModel.getUnionIntersectionTooltip());
        });
    }

    private void setupIntersectionUnionToggle() {
        this.addExtraButtonToHeader(this.intersectionUnionToggle, 0);
        this.intersectionUnionToggle.setOnAction(event -> new ToggleUnionIntersectionAction().execute());
    }

    private class ToggleUnionIntersectionAction
    extends SimpleCommand {
        private ToggleUnionIntersectionAction() {
        }

        public void execute() {
            GroupViewMode mode = GroupsSidePaneComponent.this.groupsPreferences.getGroupViewMode();
            if (mode == GroupViewMode.UNION) {
                GroupsSidePaneComponent.this.groupsPreferences.setGroupViewMode(GroupViewMode.INTERSECTION);
                GroupsSidePaneComponent.this.dialogService.notify(Localization.lang("Group view mode set to intersection", new Object[0]));
            } else if (mode == GroupViewMode.INTERSECTION) {
                GroupsSidePaneComponent.this.groupsPreferences.setGroupViewMode(GroupViewMode.UNION);
                GroupsSidePaneComponent.this.dialogService.notify(Localization.lang("Group view mode set to union", new Object[0]));
            }
        }
    }
}

