/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.slr;

import java.io.IOException;
import java.nio.file.Path;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.slr.ManageStudyDefinitionView;
import org.jabref.logic.crawler.StudyYamlParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.study.Study;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditExistingStudyAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditExistingStudyAction.class);
    private final DialogService dialogService;
    private final StateManager stateManager;

    public EditExistingStudyAction(DialogService dialogService, StateManager stateManager) {
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.executable.bind((ObservableValue)ActionHelper.needsStudyDatabase(stateManager));
    }

    public void execute() {
        Study study;
        if (this.stateManager.getActiveDatabase().isEmpty() || !this.stateManager.getActiveDatabase().get().isStudy()) {
            return;
        }
        BibDatabaseContext bibDatabaseContext = this.stateManager.getActiveDatabase().get();
        if (bibDatabaseContext.getDatabasePath().isEmpty()) {
            LOGGER.error("Library path is not available");
            return;
        }
        Path databasePath = bibDatabaseContext.getDatabasePath().get();
        Path studyDirectory = databasePath.getParent();
        try {
            study = new StudyYamlParser().parseStudyYamlFile(studyDirectory.resolve("study.yml"));
        }
        catch (IOException e) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error opening file", new Object[0]), e);
            return;
        }
        this.dialogService.showCustomDialogAndWait(new ManageStudyDefinitionView(study, studyDirectory));
    }
}

