/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.undo;

import org.jabref.gui.undo.AbstractUndoableJabRefEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.strings.StringUtil;

public class UndoableChangeType
extends AbstractUndoableJabRefEdit {
    private final EntryType oldType;
    private final EntryType newType;
    private final BibEntry entry;

    public UndoableChangeType(FieldChange change) {
        this(change.getEntry(), EntryTypeFactory.parse(change.getOldValue()), EntryTypeFactory.parse(change.getNewValue()));
    }

    public UndoableChangeType(BibEntry entry, EntryType oldType, EntryType newType) {
        this.oldType = oldType;
        this.newType = newType;
        this.entry = entry;
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("change type of entry %0 from %1 to %2", StringUtil.boldHTML(this.entry.getCitationKey().orElse(Localization.lang("undefined", new Object[0]))), StringUtil.boldHTML(this.oldType.getDisplayName(), Localization.lang("undefined", new Object[0])), StringUtil.boldHTML(this.newType.getDisplayName()));
    }

    @Override
    public void undo() {
        super.undo();
        this.entry.setType(this.oldType);
    }

    @Override
    public void redo() {
        super.redo();
        this.entry.setType(this.newType);
    }
}

