/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.undo;

import java.util.Collections;
import java.util.List;
import org.jabref.gui.undo.AbstractUndoableJabRefEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoableInsertEntries
extends AbstractUndoableJabRefEdit {
    private static final Logger LOGGER = LoggerFactory.getLogger(UndoableInsertEntries.class);
    private final BibDatabase database;
    private final List<BibEntry> entries;
    private final boolean paste;

    public UndoableInsertEntries(BibDatabase database, BibEntry entry) {
        this(database, Collections.singletonList(entry));
    }

    public UndoableInsertEntries(BibDatabase database, List<BibEntry> entries) {
        this(database, entries, false);
    }

    public UndoableInsertEntries(BibDatabase database, List<BibEntry> entries, boolean paste) {
        this.database = database;
        this.entries = entries;
        this.paste = paste;
    }

    @Override
    public String getPresentationName() {
        if (this.paste) {
            if (this.entries.size() > 1) {
                return Localization.lang("paste entries", new Object[0]);
            }
            if (this.entries.size() == 1) {
                return Localization.lang("paste entry %0", StringUtil.boldHTML(this.entries.getFirst().getCitationKey().orElse(Localization.lang("undefined", new Object[0]))));
            }
            return null;
        }
        if (this.entries.size() > 1) {
            return Localization.lang("insert entries", new Object[0]);
        }
        if (this.entries.size() == 1) {
            return Localization.lang("insert entry %0", StringUtil.boldHTML(this.entries.getFirst().getCitationKey().orElse(Localization.lang("undefined", new Object[0]))));
        }
        return null;
    }

    @Override
    public void undo() {
        super.undo();
        try {
            this.database.removeEntries(this.entries);
        }
        catch (Throwable ex) {
            LOGGER.warn("Problem undoing `insert entries`", ex);
        }
    }

    @Override
    public void redo() {
        super.redo();
        this.database.insertEntries(this.entries);
    }
}

