/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.undo;

import org.jabref.gui.undo.AbstractUndoableJabRefEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;

public class UndoableKeyChange
extends AbstractUndoableJabRefEdit {
    private final BibEntry entry;
    private final String oldValue;
    private final String newValue;

    public UndoableKeyChange(FieldChange change) {
        this(change.getEntry(), change.getOldValue(), change.getNewValue());
    }

    public UndoableKeyChange(BibEntry entry, String oldValue, String newValue) {
        this.entry = entry;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("change key from %0 to %1", StringUtil.boldHTML(this.oldValue, Localization.lang("undefined", new Object[0])), StringUtil.boldHTML(this.newValue, Localization.lang("undefined", new Object[0])));
    }

    @Override
    public void undo() {
        super.undo();
        this.entry.setCitationKey(this.oldValue);
    }

    @Override
    public void redo() {
        super.redo();
        this.entry.setCitationKey(this.newValue);
    }
}

