/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Cell;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.DragEvent;
import org.jabref.gui.util.DroppingMouseLocation;

public class ControlHelper {
    private static PseudoClass dragOverBottom = PseudoClass.getPseudoClass((String)"dragOver-bottom");
    private static PseudoClass dragOverCenter = PseudoClass.getPseudoClass((String)"dragOver-center");
    private static PseudoClass dragOverTop = PseudoClass.getPseudoClass((String)"dragOver-top");

    public static void setAction(ButtonType buttonType, DialogPane dialogPane, Consumer<Event> consumer) {
        Button button = (Button)dialogPane.lookupButton(buttonType);
        button.addEventFilter(ActionEvent.ACTION, event -> {
            consumer.accept(event);
            event.consume();
        });
    }

    public static boolean childIsFocused(Parent node) {
        return node.isFocused() || node.getChildrenUnmodifiable().stream().anyMatch(child -> {
            if (child instanceof Parent) {
                Parent parent = (Parent)child;
                return ControlHelper.childIsFocused(parent);
            }
            return child.isFocused();
        });
    }

    public static TextFormatter<String> getIntegerTextFormatter() {
        UnaryOperator filter = change -> {
            String text = change.getText();
            if (text.matches("[0-9]*")) {
                return change;
            }
            return null;
        };
        return new TextFormatter(filter);
    }

    public static void removePseudoClasses(Cell<?> cell, PseudoClass ... pseudoClasses) {
        for (PseudoClass pseudoClass : pseudoClasses) {
            cell.pseudoClassStateChanged(pseudoClass, false);
        }
    }

    public static DroppingMouseLocation getDroppingMouseLocation(Cell<?> cell, DragEvent event) {
        if (cell.getHeight() * 0.25 > event.getY()) {
            return DroppingMouseLocation.TOP;
        }
        if (cell.getHeight() * 0.75 < event.getY()) {
            return DroppingMouseLocation.BOTTOM;
        }
        return DroppingMouseLocation.CENTER;
    }

    public static void setDroppingPseudoClasses(Cell<?> cell, DragEvent event) {
        ControlHelper.removeDroppingPseudoClasses(cell);
        switch (ControlHelper.getDroppingMouseLocation(cell, event)) {
            case BOTTOM: {
                cell.pseudoClassStateChanged(dragOverBottom, true);
                break;
            }
            case CENTER: {
                cell.pseudoClassStateChanged(dragOverCenter, true);
                break;
            }
            case TOP: {
                cell.pseudoClassStateChanged(dragOverTop, true);
            }
        }
    }

    public static void setDroppingPseudoClasses(Cell<?> cell) {
        ControlHelper.removeDroppingPseudoClasses(cell);
        cell.pseudoClassStateChanged(dragOverCenter, true);
    }

    public static void removeDroppingPseudoClasses(Cell<?> cell) {
        ControlHelper.removePseudoClasses(cell, dragOverBottom, dragOverCenter, dragOverTop);
    }

    public static String truncateString(String text, int maxCharacters, String ellipsisString, EllipsisPosition ellipsisPosition) {
        if (text == null || "".equals(text)) {
            return text;
        }
        if (ellipsisString == null) {
            ellipsisString = "";
        }
        if (maxCharacters == -1) {
            maxCharacters = 75;
        }
        maxCharacters = Math.max(ellipsisString.length(), maxCharacters);
        if (text.length() > maxCharacters) {
            switch (ellipsisPosition.ordinal()) {
                case 0: {
                    return ellipsisString + text.substring(text.length() - (maxCharacters - ellipsisString.length()));
                }
                case 1: {
                    int partialLength = (int)Math.floor((float)(maxCharacters - ellipsisString.length()) / 2.0f);
                    return text.substring(0, partialLength) + ellipsisString + text.substring(text.length() - partialLength);
                }
                case 2: {
                    return text.substring(0, maxCharacters - ellipsisString.length()) + ellipsisString;
                }
            }
        }
        return text;
    }

    public static enum EllipsisPosition {
        BEGINNING,
        CENTER,
        ENDING;

    }
}

