/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.Collection;
import java.util.Collections;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.GraphicDecoration;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.decoration.GraphicValidationDecoration;
import org.jabref.gui.icon.IconTheme;

public class IconValidationDecorator
extends GraphicValidationDecoration {
    private final Pos position;

    public IconValidationDecorator() {
        this(Pos.BOTTOM_LEFT);
    }

    public IconValidationDecorator(Pos position) {
        this.position = position;
    }

    protected Node createErrorNode() {
        return IconTheme.JabRefIcons.ERROR.getGraphicNode();
    }

    protected Node createWarningNode() {
        return IconTheme.JabRefIcons.WARNING.getGraphicNode();
    }

    public Node createDecorationNode(ValidationMessage message) {
        Node graphic = Severity.ERROR == message.getSeverity() ? this.createErrorNode() : this.createWarningNode();
        graphic.getStyleClass().add((Object)(Severity.ERROR == message.getSeverity() ? "error-icon" : "warning-icon"));
        Label label = new Label();
        label.setGraphic(graphic);
        label.setTooltip(this.createTooltip(message));
        label.setAlignment(this.position);
        return label;
    }

    protected Tooltip createTooltip(ValidationMessage message) {
        Tooltip tooltip = new Tooltip(message.getText());
        tooltip.getStyleClass().add((Object)(Severity.ERROR == message.getSeverity() ? "tooltip-error" : "tooltip-warning"));
        return tooltip;
    }

    protected Collection<Decoration> createValidationDecorations(ValidationMessage message) {
        return Collections.singletonList(new GraphicDecoration(this.createDecorationNode(message), this.position));
    }
}

