/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import com.tobiasdiez.easybind.PreboundBinding;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class OptionalObjectProperty<T>
extends SimpleObjectProperty<Optional<T>> {
    private OptionalObjectProperty(Optional<T> initialValue) {
        super(initialValue);
    }

    public static <T> OptionalObjectProperty<T> empty() {
        return new OptionalObjectProperty(Optional.empty());
    }

    public ObjectBinding<T> orElseOpt(final T other) {
        return new PreboundBinding<T>(new Observable[]{this}){

            protected T computeValue() {
                return ((Optional)OptionalObjectProperty.this.getValue()).orElse(other);
            }
        };
    }

    public BooleanExpression isPresent() {
        return BooleanExpression.booleanExpression((ObservableValue)new PreboundBinding<Boolean>(new Observable[]{this}){

            protected Boolean computeValue() {
                return ((Optional)OptionalObjectProperty.this.getValue()).isPresent();
            }
        });
    }
}

