/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import com.airhacks.afterburner.injection.Injector;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import org.jabref.gui.StateManager;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.util.DelayTaskThrottler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiTaskExecutor
implements TaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UiTaskExecutor.class);
    private final ExecutorService executor = Executors.newFixedThreadPool(5);
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2);
    private final WeakHashMap<DelayTaskThrottler, Void> throttlers = new WeakHashMap();

    public static <V> V runInJavaFXThread(Callable<V> callable) {
        if (Platform.isFxApplicationThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                LOGGER.error("Problem executing call", (Throwable)e);
                return null;
            }
        }
        FutureTask<V> task = new FutureTask<V>(callable);
        Platform.runLater(task);
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Problem running in fx thread", (Throwable)e);
            return null;
        }
    }

    public static void runAndWaitInJavaFXThread(Runnable action) {
        Objects.requireNonNull(action);
        if (Platform.isFxApplicationThread()) {
            action.run();
            return;
        }
        CountDownLatch doneLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                action.run();
            }
            finally {
                doneLatch.countDown();
            }
        });
        try {
            doneLatch.await();
        }
        catch (InterruptedException e) {
            LOGGER.error("Problem running action on JavaFX thread", (Throwable)e);
        }
    }

    public static void runInJavaFXThread(Runnable runnable) {
        Platform.runLater((Runnable)runnable);
    }

    @Override
    public <V> Future<V> execute(BackgroundTask<V> task) {
        Task<V> javafxTask = this.getJavaFXTask(task);
        if (task.showToUser()) {
            StateManager stateManager = (StateManager)Injector.instantiateModelOrService(StateManager.class);
            if (stateManager != null) {
                stateManager.addBackgroundTask(task, javafxTask);
            } else {
                LOGGER.info("Background task visible without GUI");
            }
        }
        return this.execute(javafxTask);
    }

    @Override
    public <V> Future<V> execute(Task<V> task) {
        this.executor.submit((Runnable)task);
        return task;
    }

    @Override
    public <V> Future<?> schedule(BackgroundTask<V> task, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule((Runnable)this.getJavaFXTask(task), delay, unit);
    }

    @Override
    public void shutdown() {
        StateManager stateManager = (StateManager)Injector.instantiateModelOrService(StateManager.class);
        if (stateManager != null) {
            stateManager.getBackgroundTasks().stream().filter(task -> !task.isDone()).forEach(Task::cancel);
        }
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.throttlers.forEach((throttler, aVoid) -> throttler.shutdown());
    }

    @Override
    public DelayTaskThrottler createThrottler(int delay) {
        DelayTaskThrottler throttler = new DelayTaskThrottler(delay);
        this.throttlers.put(throttler, null);
        return throttler;
    }

    private <V> Task<V> getJavaFXTask(final BackgroundTask<V> task) {
        Consumer<Exception> onException;
        Consumer<V> onSuccess;
        Task javaTask = new Task<V>(this){
            {
                this.updateMessage((String)task.messageProperty().get());
                this.updateTitle((String)task.titleProperty().get());
                BindingsHelper.subscribeFuture(task.progressProperty(), progress -> this.updateProgress(progress.workDone(), progress.max()));
                BindingsHelper.subscribeFuture(task.messageProperty(), x$0 -> this.updateMessage((String)x$0));
                BindingsHelper.subscribeFuture(task.titleProperty(), x$0 -> this.updateTitle((String)x$0));
                BindingsHelper.subscribeFuture(task.isCanceledProperty(), cancelled -> {
                    if (cancelled.booleanValue()) {
                        this.cancel();
                    }
                });
                this.setOnCancelled(event -> task.cancel());
            }

            public V call() throws Exception {
                return task.call();
            }
        };
        Runnable onRunning = task.getOnRunning();
        if (onRunning != null) {
            javaTask.setOnRunning(event -> onRunning.run());
        }
        if ((onSuccess = task.getOnSuccess()) != null) {
            javaTask.setOnSucceeded(arg_0 -> UiTaskExecutor.lambda$getJavaFXTask$4(onSuccess, (Task)javaTask, arg_0));
        }
        if ((onException = task.getOnException()) != null) {
            javaTask.setOnFailed(arg_0 -> this.lambda$getJavaFXTask$5(onException, (Task)javaTask, arg_0));
        }
        return javaTask;
    }

    private Exception convertToException(Throwable throwable) {
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            return exception;
        }
        return new Exception(throwable);
    }

    private /* synthetic */ void lambda$getJavaFXTask$5(Consumer onException, Task javaTask, WorkerStateEvent event) {
        onException.accept(this.convertToException(javaTask.getException()));
    }

    private static /* synthetic */ void lambda$getJavaFXTask$4(Consumer onSuccess, Task javaTask, WorkerStateEvent event) {
        onSuccess.accept(javaTask.getValue());
    }
}

