/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import com.tobiasdiez.easybind.Subscription;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.jabref.gui.util.BindingsHelper;

public class ViewModelTextFieldTableCellVisualizationFactory<S, T>
implements Callback<TableColumn<S, T>, TableCell<S, T>> {
    private static final PseudoClass INVALID_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"invalid");
    private Function<S, ValidationStatus> validationStatusProperty;
    private StringConverter<T> stringConverter;

    public ViewModelTextFieldTableCellVisualizationFactory<S, T> withValidation(Function<S, ValidationStatus> validationStatusProperty) {
        this.validationStatusProperty = validationStatusProperty;
        return this;
    }

    public void install(TableColumn<S, T> column, StringConverter<T> stringConverter) {
        column.setCellFactory((Callback)this);
        this.stringConverter = stringConverter;
    }

    public TextFieldTableCell<S, T> call(TableColumn<S, T> param) {
        return new TextFieldTableCell<S, T>(this.stringConverter){
            final List<Subscription> subscriptions;
            {
                this.subscriptions = new ArrayList<Subscription>();
            }

            public void startEdit() {
                super.startEdit();
                this.lookupTextField().ifPresent(textField -> Platform.runLater(() -> {
                    textField.requestFocus();
                    textField.selectAll();
                }));
            }

            private Optional<TextField> lookupTextField() {
                HBox hbox;
                if (this.getGraphic() instanceof TextField) {
                    return Optional.of((TextField)this.getGraphic());
                }
                if (this.getGraphic() instanceof HBox && (hbox = (HBox)this.getGraphic()).getChildren().size() > 1 && hbox.getChildren().get(1) instanceof TextField) {
                    return Optional.of((TextField)hbox.getChildren().get(1));
                }
                return Optional.empty();
            }

            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                this.subscriptions.forEach(Subscription::unsubscribe);
                this.subscriptions.clear();
                if (empty || this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setOnMouseClicked(null);
                    this.setTooltip(null);
                    this.pseudoClassStateChanged(INVALID_PSEUDO_CLASS, false);
                } else {
                    Object viewModel = this.getTableRow().getItem();
                    if (ViewModelTextFieldTableCellVisualizationFactory.this.validationStatusProperty != null) {
                        ViewModelTextFieldTableCellVisualizationFactory.this.validationStatusProperty.apply(viewModel).getHighestMessage().ifPresent(message -> this.setTooltip(new Tooltip(message.getMessage())));
                        this.subscriptions.add(BindingsHelper.includePseudoClassWhen((Node)this, INVALID_PSEUDO_CLASS, (ObservableValue<? extends Boolean>)ViewModelTextFieldTableCellVisualizationFactory.this.validationStatusProperty.apply(viewModel).validProperty().not()));
                    }
                }
            }
        };
    }
}

