/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex.comparator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.bibtex.comparator.BibEntryDiff;
import org.jabref.logic.bibtex.comparator.BibStringDiff;
import org.jabref.logic.bibtex.comparator.EntryComparator;
import org.jabref.logic.bibtex.comparator.MetaDataDiff;
import org.jabref.logic.bibtex.comparator.PreambleDiff;
import org.jabref.logic.database.DuplicateCheck;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.StandardField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BibDatabaseDiff {
    private static final Logger LOGGER = LoggerFactory.getLogger(BibDatabaseDiff.class);
    private static final double MATCH_THRESHOLD = 0.4;
    private final Optional<MetaDataDiff> metaDataDiff;
    private final Optional<PreambleDiff> preambleDiff;
    private final List<BibStringDiff> bibStringDiffs;
    private final List<BibEntryDiff> entryDiffs;

    private BibDatabaseDiff(BibDatabaseContext originalDatabase, BibDatabaseContext newDatabase) {
        this.metaDataDiff = MetaDataDiff.compare(originalDatabase.getMetaData(), newDatabase.getMetaData());
        this.preambleDiff = PreambleDiff.compare(originalDatabase, newDatabase);
        this.bibStringDiffs = BibStringDiff.compare(originalDatabase.getDatabase(), newDatabase.getDatabase());
        this.entryDiffs = this.getBibEntryDiffs(originalDatabase, newDatabase);
        if (LOGGER.isDebugEnabled() && !this.isEmpty()) {
            LOGGER.debug("Differences detected");
            this.metaDataDiff.ifPresent(diff -> LOGGER.debug("Metadata differences: {}", diff));
            this.preambleDiff.ifPresent(diff -> LOGGER.debug("Premble differences: {}", diff));
            LOGGER.debug("BibString differences: {}", this.bibStringDiffs);
            LOGGER.debug("Entry differences: {}", this.entryDiffs);
        }
    }

    private boolean isEmpty() {
        return !this.metaDataDiff.isPresent() && !this.preambleDiff.isPresent() && this.bibStringDiffs.isEmpty() && this.entryDiffs.isEmpty();
    }

    private List<BibEntryDiff> getBibEntryDiffs(BibDatabaseContext originalDatabase, BibDatabaseContext newDatabase) {
        EntryComparator comparator = BibDatabaseDiff.getEntryComparator();
        List<BibEntry> originalEntriesSorted = originalDatabase.getDatabase().getEntriesSorted(comparator);
        List<BibEntry> newEntriesSorted = newDatabase.getDatabase().getEntriesSorted(comparator);
        originalEntriesSorted.removeIf(BibEntry::isEmpty);
        newEntriesSorted.removeIf(BibEntry::isEmpty);
        List<BibEntryDiff> entryDiffs = BibDatabaseDiff.compareEntries(originalEntriesSorted, newEntriesSorted, originalDatabase.getMode());
        return entryDiffs;
    }

    private static EntryComparator getEntryComparator() {
        EntryComparator comparator = new EntryComparator(false, true, StandardField.TITLE);
        comparator = new EntryComparator(false, true, StandardField.AUTHOR, comparator);
        comparator = new EntryComparator(false, true, StandardField.YEAR, comparator);
        return comparator;
    }

    /*
     * WARNING - void declaration
     */
    private static List<BibEntryDiff> compareEntries(List<BibEntry> originalEntries, List<BibEntry> newEntries, BibDatabaseMode mode) {
        void var7_10;
        ArrayList<BibEntryDiff> differences = new ArrayList<BibEntryDiff>();
        if (newEntries.isEmpty()) {
            return differences;
        }
        HashSet<Integer> matchedEntries = new HashSet<Integer>(newEntries.size());
        HashSet<BibEntry> notMatched = new HashSet<BibEntry>(originalEntries.size());
        block0: for (BibEntry bibEntry : originalEntries) {
            for (int i = 0; i < newEntries.size(); ++i) {
                double score;
                if (matchedEntries.contains(i) || !((score = DuplicateCheck.compareEntriesStrictly(bibEntry, newEntries.get(i))) > 1.0)) continue;
                matchedEntries.add(i);
                continue block0;
            }
            notMatched.add(bibEntry);
        }
        DuplicateCheck duplicateCheck = new DuplicateCheck(new BibEntryTypesManager());
        for (BibEntry bibEntry : notMatched) {
            double bestMatch = 0.0;
            int bestMatchIndex = 0;
            for (int i = 0; i < newEntries.size(); ++i) {
                double score;
                if (matchedEntries.contains(i) || !((score = DuplicateCheck.compareEntriesStrictly(bibEntry, newEntries.get(i))) > bestMatch)) continue;
                bestMatch = score;
                bestMatchIndex = i;
            }
            BibEntry bestEntry = newEntries.get(bestMatchIndex);
            if (bestMatch > 0.4 || BibDatabaseDiff.hasEqualCitationKey(bibEntry, bestEntry) || duplicateCheck.isDuplicate(bibEntry, bestEntry, mode)) {
                matchedEntries.add(bestMatchIndex);
                differences.add(new BibEntryDiff(bibEntry, newEntries.get(bestMatchIndex)));
                continue;
            }
            differences.add(new BibEntryDiff(bibEntry, null));
        }
        boolean bl = false;
        while (var7_10 < newEntries.size()) {
            if (!matchedEntries.contains((int)var7_10)) {
                differences.add(new BibEntryDiff(null, newEntries.get((int)var7_10)));
            }
            ++var7_10;
        }
        return differences;
    }

    private static boolean hasEqualCitationKey(BibEntry oneEntry, BibEntry twoEntry) {
        return oneEntry.hasCitationKey() && twoEntry.hasCitationKey() && oneEntry.getCitationKey().equals(twoEntry.getCitationKey());
    }

    public static BibDatabaseDiff compare(BibDatabaseContext base, BibDatabaseContext changed) {
        return new BibDatabaseDiff(base, changed);
    }

    public Optional<MetaDataDiff> getMetaDataDifferences() {
        return this.metaDataDiff;
    }

    public Optional<PreambleDiff> getPreambleDifferences() {
        return this.preambleDiff;
    }

    public List<BibStringDiff> getBibStringDifferences() {
        return this.bibStringDiffs;
    }

    public List<BibEntryDiff> getEntryDifferences() {
        return this.entryDiffs;
    }
}

