/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex.comparator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibtexString;

public class BibStringDiff {
    private final BibtexString originalString;
    private final BibtexString newString;

    BibStringDiff(BibtexString originalString, BibtexString newString) {
        this.originalString = originalString;
        this.newString = newString;
    }

    public static List<BibStringDiff> compare(BibDatabase originalDatabase, BibDatabase newDatabase) {
        Optional<BibtexString> match;
        if (originalDatabase.hasNoStrings() && newDatabase.hasNoStrings()) {
            return Collections.emptyList();
        }
        ArrayList<BibStringDiff> differences = new ArrayList<BibStringDiff>();
        HashSet<BibtexString> used = new HashSet<BibtexString>();
        HashSet<BibtexString> notMatched = new HashSet<BibtexString>();
        for (BibtexString original : originalDatabase.getStringValues()) {
            match = newDatabase.getStringValues().stream().filter(test -> test.getName().equals(original.getName())).findAny();
            if (match.isPresent()) {
                if (!Objects.equals(original.getContent(), match.get().getContent())) {
                    differences.add(new BibStringDiff(original, match.get()));
                }
                used.add(match.get());
                continue;
            }
            notMatched.add(original);
        }
        Iterator iterator = notMatched.iterator();
        while (iterator.hasNext()) {
            BibtexString original;
            original = (BibtexString)iterator.next();
            match = newDatabase.getStringValues().stream().filter(test -> test.getContent().equals(original.getContent())).findAny();
            if (!match.isPresent()) continue;
            differences.add(new BibStringDiff(original, match.get()));
            iterator.remove();
            used.add(match.get());
        }
        for (BibtexString original : notMatched) {
            differences.add(new BibStringDiff(original, null));
        }
        newDatabase.getStringValues().stream().filter(test -> !used.contains(test)).forEach(newString -> differences.add(new BibStringDiff(null, (BibtexString)newString)));
        return differences;
    }

    public BibtexString getOriginalString() {
        return this.originalString;
    }

    public BibtexString getNewString() {
        return this.newString;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BibStringDiff that = (BibStringDiff)other;
        return Objects.equals(this.newString, that.newString) && Objects.equals(this.originalString, that.originalString);
    }

    public int hashCode() {
        return Objects.hash(this.originalString, this.newString);
    }
}

