/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex.comparator;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Month;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.metadata.SaveOrder;
import org.jabref.model.strings.StringUtil;

public class FieldComparator
implements Comparator<BibEntry> {
    private static final Collator COLLATOR = FieldComparator.getCollator();
    private final OrFields fields;
    private final FieldType fieldType;
    private final boolean isNumeric;
    private final int multiplier;

    public FieldComparator(Field field) {
        this(new OrFields(field), false);
    }

    public FieldComparator(SaveOrder.SortCriterion sortCriterion) {
        this(new OrFields(sortCriterion.field), sortCriterion.descending);
    }

    public FieldComparator(OrFields fields, boolean descending) {
        this.fields = fields;
        this.fieldType = this.determineFieldType();
        this.isNumeric = this.fields.getPrimary().isNumeric();
        this.multiplier = descending ? -1 : 1;
    }

    private static Collator getCollator() {
        try {
            return new RuleBasedCollator(((RuleBasedCollator)Collator.getInstance()).getRules().replace("<'_'", "<' '<'_'"));
        }
        catch (ParseException e) {
            return Collator.getInstance();
        }
    }

    private FieldType determineFieldType() {
        if (InternalField.TYPE_HEADER == this.fields.getPrimary()) {
            return FieldType.TYPE;
        }
        if (this.fields.getPrimary().getProperties().contains((Object)FieldProperty.PERSON_NAMES)) {
            return FieldType.NAME;
        }
        if (StandardField.YEAR == this.fields.getPrimary()) {
            return FieldType.YEAR;
        }
        if (StandardField.MONTH == this.fields.getPrimary()) {
            return FieldType.MONTH;
        }
        return FieldType.OTHER;
    }

    private String getFieldValue(BibEntry entry) {
        for (Field aField : this.fields.getFields()) {
            Optional<String> o = entry.getFieldOrAliasLatexFree(aField);
            if (!o.isPresent()) continue;
            return o.get();
        }
        return null;
    }

    @Override
    public int compare(BibEntry e1, BibEntry e2) {
        String f2;
        String f1;
        if (this.fieldType == FieldType.TYPE) {
            f1 = e1.getType().getDisplayName();
            f2 = e2.getType().getDisplayName();
        } else {
            f1 = this.getFieldValue(e1);
            f2 = this.getFieldValue(e2);
        }
        if (f1 == null && f2 == null) {
            return 0;
        }
        if (f1 == null) {
            return -this.multiplier;
        }
        if (f2 == null) {
            return this.multiplier;
        }
        if (this.fieldType == FieldType.NAME) {
            f1 = AuthorList.fixAuthorForAlphabetization(f1);
            f2 = AuthorList.fixAuthorForAlphabetization(f2);
        } else {
            if (this.fieldType == FieldType.YEAR) {
                int f2year;
                int f1year;
                try {
                    f1year = StringUtil.intValueOf(f1);
                }
                catch (NumberFormatException ex) {
                    f1year = 0;
                }
                try {
                    f2year = StringUtil.intValueOf(f2);
                }
                catch (NumberFormatException ex) {
                    f2year = 0;
                }
                int comparisonResult = Integer.compare(f1year, f2year);
                return comparisonResult * this.multiplier;
            }
            if (this.fieldType == FieldType.MONTH) {
                int month1 = Month.parse(f1).map(Month::getNumber).orElse(-1);
                int month2 = Month.parse(f2).map(Month::getNumber).orElse(-1);
                return Integer.compare(month1, month2) * this.multiplier;
            }
        }
        if (this.isNumeric) {
            boolean i2present;
            int i2;
            boolean i1present;
            int i1;
            try {
                i1 = StringUtil.intValueOf(f1);
                i1present = true;
            }
            catch (NumberFormatException ex) {
                i1 = 0;
                i1present = false;
            }
            try {
                i2 = StringUtil.intValueOf(f2);
                i2present = true;
            }
            catch (NumberFormatException ex) {
                i2 = 0;
                i2present = false;
            }
            if (i1present && i2present) {
                return Integer.compare(i1, i2) * this.multiplier;
            }
            if (i1present) {
                return -1 * this.multiplier;
            }
            if (i2present) {
                return this.multiplier;
            }
        }
        String ours = f1.toLowerCase(Locale.ENGLISH);
        String theirs = f2.toLowerCase(Locale.ENGLISH);
        return COLLATOR.compare(ours, theirs) * this.multiplier;
    }

    static enum FieldType {
        NAME,
        TYPE,
        YEAR,
        MONTH,
        OTHER;

    }
}

