/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex.comparator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.bibtex.comparator.GroupDiff;
import org.jabref.logic.citationkeypattern.CitationKeyPattern;
import org.jabref.logic.citationkeypattern.GlobalCitationKeyPatterns;
import org.jabref.logic.groups.DefaultGroupsFactory;
import org.jabref.model.entry.field.Field;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.metadata.ContentSelectors;
import org.jabref.model.metadata.MetaData;

public class MetaDataDiff {
    private final Optional<GroupDiff> groupDiff;
    private final MetaData originalMetaData;
    private final MetaData newMetaData;

    private MetaDataDiff(MetaData originalMetaData, MetaData newMetaData) {
        this.originalMetaData = originalMetaData;
        this.newMetaData = newMetaData;
        this.groupDiff = GroupDiff.compare(originalMetaData, newMetaData);
    }

    public static Optional<MetaDataDiff> compare(MetaData originalMetaData, MetaData newMetaData) {
        if (originalMetaData.equals(newMetaData)) {
            return Optional.empty();
        }
        MetaDataDiff diff = new MetaDataDiff(originalMetaData, newMetaData);
        List<Difference> differences = diff.getDifferences(new GlobalCitationKeyPatterns(CitationKeyPattern.NULL_CITATION_KEY_PATTERN));
        if (differences.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(diff);
    }

    private static boolean isDefaultContentSelectors(ContentSelectors contentSelectors) {
        if (contentSelectors.getContentSelectors().isEmpty()) {
            return true;
        }
        Map<Field, List<String>> fieldKeywordsMap = ContentSelectors.getFieldKeywordsMap(contentSelectors.getContentSelectors());
        return ContentSelectors.isDefaultMap(fieldKeywordsMap);
    }

    private void addToListIfDiff(List<Difference> changes, DifferenceType differenceType, Object originalObject, Object newObject) {
        if (!Objects.equals(originalObject, newObject)) {
            if (differenceType == DifferenceType.CONTENT_SELECTOR) {
                ContentSelectors originalContentSelectors = (ContentSelectors)originalObject;
                ContentSelectors newContentSelectors = (ContentSelectors)newObject;
                if (MetaDataDiff.isDefaultContentSelectors(originalContentSelectors) && MetaDataDiff.isDefaultContentSelectors(newContentSelectors)) {
                    return;
                }
            } else if (differenceType == DifferenceType.GROUPS) {
                Optional originalGroups = (Optional)originalObject;
                Optional newGroups = (Optional)newObject;
                if (this.isDefaultGroup(originalGroups) && this.isDefaultGroup(newGroups)) {
                    return;
                }
            }
            changes.add(new Difference(differenceType, originalObject, newObject));
        }
    }

    private boolean isDefaultGroup(Optional<GroupTreeNode> groups) {
        if (groups.isEmpty()) {
            return true;
        }
        GroupTreeNode groupRoot = groups.get();
        if (!groupRoot.getChildren().isEmpty()) {
            return false;
        }
        return groupRoot.getGroup().equals(DefaultGroupsFactory.getAllEntriesGroup());
    }

    public List<Difference> getDifferences(GlobalCitationKeyPatterns globalCitationKeyPatterns) {
        ArrayList<Difference> changes = new ArrayList<Difference>();
        this.addToListIfDiff(changes, DifferenceType.PROTECTED, this.originalMetaData.isProtected(), this.newMetaData.isProtected());
        this.addToListIfDiff(changes, DifferenceType.GROUPS, this.originalMetaData.getGroups(), this.newMetaData.getGroups());
        this.addToListIfDiff(changes, DifferenceType.ENCODING, this.originalMetaData.getEncoding(), this.newMetaData.getEncoding());
        this.addToListIfDiff(changes, DifferenceType.SAVE_SORT_ORDER, this.originalMetaData.getSaveOrder(), this.newMetaData.getSaveOrder());
        this.addToListIfDiff(changes, DifferenceType.KEY_PATTERNS, this.originalMetaData.getCiteKeyPatterns(globalCitationKeyPatterns), this.newMetaData.getCiteKeyPatterns(globalCitationKeyPatterns));
        this.addToListIfDiff(changes, DifferenceType.USER_FILE_DIRECTORY, this.originalMetaData.getUserFileDirectories(), this.newMetaData.getUserFileDirectories());
        this.addToListIfDiff(changes, DifferenceType.LATEX_FILE_DIRECTORY, this.originalMetaData.getLatexFileDirectories(), this.newMetaData.getLatexFileDirectories());
        this.addToListIfDiff(changes, DifferenceType.DEFAULT_KEY_PATTERN, this.originalMetaData.getDefaultCiteKeyPattern(), this.newMetaData.getDefaultCiteKeyPattern());
        this.addToListIfDiff(changes, DifferenceType.SAVE_ACTIONS, this.originalMetaData.getSaveActions(), this.newMetaData.getSaveActions());
        this.addToListIfDiff(changes, DifferenceType.MODE, this.originalMetaData.getMode(), this.newMetaData.getMode());
        this.addToListIfDiff(changes, DifferenceType.GENERAL_FILE_DIRECTORY, this.originalMetaData.getDefaultFileDirectory(), this.newMetaData.getDefaultFileDirectory());
        this.addToListIfDiff(changes, DifferenceType.CONTENT_SELECTOR, this.originalMetaData.getContentSelectors(), this.newMetaData.getContentSelectors());
        return changes;
    }

    public MetaData getNewMetaData() {
        return this.newMetaData;
    }

    public Optional<GroupDiff> getGroupDifferences() {
        return this.groupDiff;
    }

    public String toString() {
        return "MetaDataDiff{groupDiff=" + String.valueOf(this.groupDiff) + ", originalMetaData=" + String.valueOf(this.originalMetaData) + ", newMetaData=" + String.valueOf(this.getNewMetaData()) + ", getDifferences()=" + String.valueOf(this.getDifferences(new GlobalCitationKeyPatterns(CitationKeyPattern.NULL_CITATION_KEY_PATTERN))) + "}";
    }

    public static enum DifferenceType {
        CONTENT_SELECTOR,
        DEFAULT_KEY_PATTERN,
        ENCODING,
        GENERAL_FILE_DIRECTORY,
        GROUPS,
        KEY_PATTERNS,
        LATEX_FILE_DIRECTORY,
        MODE,
        PROTECTED,
        SAVE_ACTIONS,
        SAVE_SORT_ORDER,
        USER_FILE_DIRECTORY;

    }

    public record Difference(DifferenceType differenceType, Object originalObject, Object newObject) {
    }
}

