/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.citationstyle;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.Subscribe;
import java.util.Objects;
import org.jabref.logic.preview.PreviewLayout;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.event.EntriesRemovedEvent;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.event.EntryChangedEvent;

public class CitationStyleCache {
    private static final int CACHE_SIZE = 1024;
    private PreviewLayout citationStyle;
    private final LoadingCache<BibEntry, String> citationStyleCache;

    public CitationStyleCache(final BibDatabaseContext databaseContext) {
        this.citationStyleCache = CacheBuilder.newBuilder().maximumSize(1024L).build((CacheLoader)new CacheLoader<BibEntry, String>(){

            public String load(BibEntry entry) {
                if (CitationStyleCache.this.citationStyle != null) {
                    return CitationStyleCache.this.citationStyle.generatePreview(entry, databaseContext);
                }
                return "";
            }
        });
        databaseContext.getDatabase().registerListener(new BibDatabaseEntryListener());
    }

    public String getCitationFor(BibEntry entry) {
        return (String)this.citationStyleCache.getUnchecked((Object)entry);
    }

    public void setCitationStyle(PreviewLayout citationStyle) {
        Objects.requireNonNull(citationStyle);
        if (!this.citationStyle.equals(citationStyle)) {
            this.citationStyle = citationStyle;
            this.citationStyleCache.invalidateAll();
        }
    }

    private class BibDatabaseEntryListener {
        private BibDatabaseEntryListener() {
        }

        @Subscribe
        public void listen(EntryChangedEvent entryChangedEvent) {
            CitationStyleCache.this.citationStyleCache.invalidate((Object)entryChangedEvent.getBibEntry());
        }

        @Subscribe
        public void listen(EntriesRemovedEvent entriesRemovedEvent) {
            for (BibEntry entry : entriesRemovedEvent.getBibEntries()) {
                CitationStyleCache.this.citationStyleCache.invalidate((Object)entry);
            }
        }
    }
}

