/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.citationstyle;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jabref.logic.citationstyle.CSLAdapter;
import org.jabref.logic.citationstyle.CitationStyle;
import org.jabref.logic.citationstyle.CitationStyleOutputFormat;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jbibtex.TokenMgrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitationStyleGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CitationStyleGenerator.class);
    private static final CSLAdapter CSL_ADAPTER = new CSLAdapter();

    private CitationStyleGenerator() {
    }

    protected static String generateCitation(BibEntry entry, CitationStyle style, BibEntryTypesManager entryTypesManager) {
        return CitationStyleGenerator.generateCitation(entry, style.getSource(), entryTypesManager);
    }

    protected static String generateCitation(BibEntry entry, String style, BibEntryTypesManager entryTypesManager) {
        return CitationStyleGenerator.generateCitation(entry, style, CitationStyleOutputFormat.HTML, new BibDatabaseContext(), entryTypesManager);
    }

    public static String generateCitation(BibEntry entry, String style, CitationStyleOutputFormat outputFormat, BibDatabaseContext databaseContext, BibEntryTypesManager entryTypesManager) {
        return CitationStyleGenerator.generateCitations(Collections.singletonList(entry), style, outputFormat, databaseContext, entryTypesManager).stream().findFirst().orElse("");
    }

    public static List<String> generateCitations(List<BibEntry> bibEntries, String style, CitationStyleOutputFormat outputFormat, BibDatabaseContext databaseContext, BibEntryTypesManager entryTypesManager) {
        try {
            return CSL_ADAPTER.makeBibliography(bibEntries, style, outputFormat, databaseContext, entryTypesManager);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Could not generate BibEntry citation. The CSL engine could not create a preview for your item.", (Throwable)e);
            return Collections.singletonList(Localization.lang("Cannot generate preview based on selected citation style.", new Object[0]));
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            LOGGER.error("Could not generate BibEntry citation", (Throwable)e);
            return Collections.singletonList(Localization.lang("Cannot generate preview based on selected citation style.", new Object[0]));
        }
        catch (TokenMgrException e) {
            LOGGER.error("Bad character inside BibEntry", (Throwable)e);
            return Collections.singletonList(Localization.lang("Cannot generate preview based on selected citation style.", new Object[0]) + outputFormat.getLineSeparator() + Localization.lang("Bad character inside entry", new Object[0]) + outputFormat.getLineSeparator() + e.getLocalizedMessage());
        }
    }
}

