/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.List;
import java.util.Optional;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.util.OptionalUtil;

public class MoveFieldCleanup
implements CleanupJob {
    private Field sourceField;
    private Field targetField;

    public MoveFieldCleanup(Field sourceField, Field targetField) {
        this.sourceField = sourceField;
        this.targetField = targetField;
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        Optional setFieldChange = entry.getField(this.sourceField).flatMap(value -> entry.setField(this.targetField, (String)value));
        Optional<FieldChange> clearFieldChange = entry.clearField(this.sourceField);
        return OptionalUtil.toList(setFieldChange, clearFieldChange);
    }
}

