/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.crawler;

import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ImporterPreferences;
import org.jabref.logic.importer.SearchBasedFetcher;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.model.study.StudyDatabase;

class StudyCatalogToFetcherConverter {
    private final List<StudyDatabase> libraryEntries;
    private final ImportFormatPreferences importFormatPreferences;
    private final ImporterPreferences importerPreferences;

    public StudyCatalogToFetcherConverter(List<StudyDatabase> libraryEntries, ImportFormatPreferences importFormatPreferences, ImporterPreferences importerPreferences) {
        this.libraryEntries = libraryEntries;
        this.importFormatPreferences = importFormatPreferences;
        this.importerPreferences = importerPreferences;
    }

    public List<SearchBasedFetcher> getActiveFetchers() {
        return this.getFetchersFromLibraryEntries(this.libraryEntries);
    }

    private List<SearchBasedFetcher> getFetchersFromLibraryEntries(List<StudyDatabase> libraryEntries) {
        return libraryEntries.parallelStream().map(this::createFetcherFromLibraryEntry).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private SearchBasedFetcher createFetcherFromLibraryEntry(StudyDatabase studyDatabase) {
        SortedSet<SearchBasedFetcher> searchBasedFetchers = WebFetchers.getSearchBasedFetchers(this.importFormatPreferences, this.importerPreferences);
        String libraryNameFromFetcher = studyDatabase.getName();
        return searchBasedFetchers.stream().filter(searchBasedFetcher -> searchBasedFetcher.getName().equalsIgnoreCase(libraryNameFromFetcher)).findAny().orElse(null);
    }
}

