/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.crawler;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.jabref.model.study.Study;

public class StudyYamlParser {
    public Study parseStudyYamlFile(Path studyYamlFile) throws IOException {
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try (FileInputStream fileInputStream = new FileInputStream(studyYamlFile.toFile());){
            Study study = (Study)yamlMapper.readValue((InputStream)fileInputStream, Study.class);
            return study;
        }
    }

    public void writeStudyYamlFile(Study study, Path studyYamlFile) throws IOException {
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES));
        yamlMapper.writeValue(studyYamlFile.toFile(), (Object)study);
    }
}

