/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Date;
import org.jabref.model.entry.field.BiblatexSoftwareField;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.StandardEntryType;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class CffExporter
extends Exporter {
    public static final List<String> UNMAPPED_FIELDS = List.of("abbreviation", "collection-doi", "collection-title", "collection-type", "commit", "copyright", "data-type", "database", "date-accessed", "date-downloaded", "date-published", "department", "end", "entry", "filename", "format", "issue-date", "issue-title", "license-url", "loc-end", "loc-start", "medium", "nihmsid", "number-volumes", "patent-states", "pmcid", "repository-artifact", "repository-code", "scope", "section", "start", "term", "thesis-type", "volume-title", "year-original");
    public static final Map<Field, String> FIELDS_MAP = Map.ofEntries(Map.entry(StandardField.ABSTRACT, "abstract"), Map.entry(StandardField.DATE, "date-released"), Map.entry(StandardField.DOI, "doi"), Map.entry(StandardField.KEYWORDS, "keywords"), Map.entry(BiblatexSoftwareField.LICENSE, "license"), Map.entry(StandardField.COMMENT, "message"), Map.entry(BiblatexSoftwareField.REPOSITORY, "repository"), Map.entry(StandardField.TITLE, "title"), Map.entry(StandardField.URL, "url"), Map.entry(StandardField.VERSION, "version"), Map.entry(StandardField.EDITION, "edition"), Map.entry(StandardField.ISBN, "isbn"), Map.entry(StandardField.ISSN, "issn"), Map.entry(StandardField.ISSUE, "issue"), Map.entry(StandardField.JOURNAL, "journal"), Map.entry(StandardField.MONTH, "month"), Map.entry(StandardField.NOTE, "notes"), Map.entry(StandardField.NUMBER, "number"), Map.entry(StandardField.PAGES, "pages"), Map.entry(StandardField.PUBSTATE, "status"), Map.entry(StandardField.VOLUME, "volume"), Map.entry(StandardField.YEAR, "year"));
    public static final Map<EntryType, String> TYPES_MAP = Map.ofEntries(Map.entry(StandardEntryType.Article, "article"), Map.entry(StandardEntryType.Book, "book"), Map.entry(StandardEntryType.Booklet, "pamphlet"), Map.entry(StandardEntryType.Proceedings, "conference"), Map.entry(StandardEntryType.InProceedings, "conference-paper"), Map.entry(StandardEntryType.Misc, "misc"), Map.entry(StandardEntryType.Manual, "manual"), Map.entry(StandardEntryType.Software, "software"), Map.entry(StandardEntryType.Dataset, "dataset"), Map.entry(StandardEntryType.Report, "report"), Map.entry(StandardEntryType.Unpublished, "unpublished"));

    public CffExporter() {
        super("cff", "CFF", StandardFileType.CFF);
    }

    @Override
    public void export(BibDatabaseContext databaseContext, Path file, List<BibEntry> entries) throws Exception {
        Objects.requireNonNull(databaseContext);
        Objects.requireNonNull(file);
        Objects.requireNonNull(entries);
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<BibEntry> entriesToTransform = new ArrayList<BibEntry>(entries);
        DumperOptions options = new DumperOptions();
        options.setWidth(Integer.MAX_VALUE);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        options.setIndentWithIndicator(true);
        options.setIndicatorIndent(2);
        Yaml yaml = new Yaml(options);
        BibEntry main = null;
        boolean mainIsDummy = false;
        int countOfSoftwareAndDataSetEntries = 0;
        for (BibEntry entry2 : entriesToTransform) {
            if (entry2.getType() != StandardEntryType.Software && entry2.getType() != StandardEntryType.Dataset) continue;
            main = entry2;
            ++countOfSoftwareAndDataSetEntries;
        }
        if (countOfSoftwareAndDataSetEntries == 1) {
            entriesToTransform.remove(main);
        } else {
            main = new BibEntry(StandardEntryType.Software);
            mainIsDummy = true;
        }
        Map<String, Object> cffData = this.transformEntry(main, true, mainIsDummy);
        if (main.hasField(StandardField.CITES)) {
            String citeKey = main.getField(StandardField.CITES).orElse("").split(",")[0];
            List<BibEntry> citedEntries = databaseContext.getDatabase().getEntriesByCitationKey(citeKey);
            entriesToTransform.removeAll(citedEntries);
            if (!citedEntries.isEmpty()) {
                BibEntry citedEntry = (BibEntry)citedEntries.getFirst();
                cffData.put("preferred-citation", this.transformEntry(citedEntry, false, false));
            }
        }
        ArrayList<Map<String, Object>> related = new ArrayList<Map<String, Object>>();
        if (main.hasField(StandardField.RELATED)) {
            main.getEntryLinkList(StandardField.RELATED, databaseContext.getDatabase()).stream().map(link -> link.getLinkedEntry()).filter(Optional::isPresent).map(Optional::get).forEach(entry -> {
                related.add(this.transformEntry((BibEntry)entry, false, false));
                entriesToTransform.remove(entry);
            });
        }
        for (BibEntry entry3 : entriesToTransform) {
            related.add(this.transformEntry(entry3, false, false));
        }
        if (!related.isEmpty()) {
            cffData.put("references", related);
        }
        try (FileWriter writer = new FileWriter(file.toFile(), StandardCharsets.UTF_8);){
            yaml.dump(cffData, (Writer)writer);
        }
        catch (IOException ex) {
            throw new SaveException(ex);
        }
    }

    private Map<String, Object> transformEntry(BibEntry entry, boolean main, boolean dummy) {
        String keywords;
        LinkedHashMap<String, Object> cffData = new LinkedHashMap<String, Object>();
        HashMap<Field, String> fields = new HashMap<Field, String>(entry.getFieldMap());
        if (main) {
            cffData.put("cff-version", "1.2.0");
            String message = fields.getOrDefault(StandardField.COMMENT, "If you use this software, please cite it using the metadata from this file.");
            cffData.put("message", message);
            fields.remove(StandardField.COMMENT);
        }
        String title = fields.getOrDefault(StandardField.TITLE, "No title specified.");
        cffData.put("title", title);
        fields.remove(StandardField.TITLE);
        List<Author> authors = AuthorList.parse(fields.getOrDefault(StandardField.AUTHOR, "")).getAuthors();
        this.parseAuthors(cffData, authors);
        fields.remove(StandardField.AUTHOR);
        if (!dummy) {
            cffData.put("type", TYPES_MAP.getOrDefault(entry.getType(), "misc"));
        }
        if ((keywords = (String)fields.getOrDefault(StandardField.KEYWORDS, null)) != null) {
            cffData.put("keywords", keywords.split(",\\s*"));
        }
        fields.remove(StandardField.KEYWORDS);
        String date = fields.getOrDefault(StandardField.DATE, null);
        if (date != null) {
            this.parseDate(cffData, date);
        }
        fields.remove(StandardField.DATE);
        for (Field field : fields.keySet()) {
            if (FIELDS_MAP.containsKey(field)) {
                cffData.put(FIELDS_MAP.get(field), fields.get(field));
                continue;
            }
            if (!(field instanceof UnknownField) || !UNMAPPED_FIELDS.contains(field.getName())) continue;
            cffData.put(field.getName(), fields.get(field));
        }
        return cffData;
    }

    private void parseAuthors(Map<String, Object> data, List<Author> authors) {
        ArrayList authorsList = new ArrayList();
        authors.forEach(author -> {
            LinkedHashMap<String, String> authorMap = new LinkedHashMap<String, String>();
            if (author.getFamilyName().isPresent()) {
                authorMap.put("family-names", author.getFamilyName().get());
            }
            if (author.getGivenName().isPresent()) {
                authorMap.put("given-names", author.getGivenName().get());
            }
            if (author.getNamePrefix().isPresent()) {
                authorMap.put("name-particle", author.getNamePrefix().get());
            }
            if (author.getNameSuffix().isPresent()) {
                authorMap.put("name-suffix", author.getNameSuffix().get());
            }
            authorsList.add(authorMap);
        });
        data.put("authors", authorsList.isEmpty() ? List.of(Map.of("name", "/")) : authorsList);
    }

    private void parseDate(Map<String, Object> data, String date) {
        Optional<Date> parsedDateOpt = Date.parse(date);
        if (parsedDateOpt.isEmpty()) {
            data.put("issue-date", date);
            return;
        }
        Date parsedDate = parsedDateOpt.get();
        if (parsedDate.getYear().isPresent() && parsedDate.getMonth().isPresent() && parsedDate.getDay().isPresent()) {
            data.put("date-released", parsedDate.getNormalized());
            return;
        }
        parsedDate.getMonth().ifPresent(month -> data.put("month", month.getNumber()));
        parsedDate.getYear().ifPresent(year -> data.put("year", year));
    }
}

