/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.util.FileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.FilePreferences;

public abstract class Exporter {
    private final String id;
    private final String displayName;
    private final FileType fileType;

    public Exporter(String id, String displayName, FileType extension) {
        this.id = id;
        this.displayName = displayName;
        this.fileType = extension;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.displayName;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public String toString() {
        return this.displayName;
    }

    public abstract void export(BibDatabaseContext var1, Path var2, List<BibEntry> var3) throws Exception;

    public void export(BibDatabaseContext databaseContext, Path file, List<BibEntry> entries, List<Path> fileDirForDatabase, JournalAbbreviationRepository abbreviationRepository) throws Exception {
        this.export(databaseContext, file, entries);
    }

    public boolean exportToAllFilesOfEntry(BibDatabaseContext databaseContext, FilePreferences filePreferences, BibEntry entryToWriteOn, List<BibEntry> entriesToWrite, JournalAbbreviationRepository abbreviationRepository) throws Exception {
        boolean writtenToAFile = false;
        for (LinkedFile file : entryToWriteOn.getFiles()) {
            Optional<Path> filePath;
            if (!file.getFileType().equals(this.fileType.getName()) || !(filePath = file.findIn(databaseContext, filePreferences)).isPresent()) continue;
            this.export(databaseContext, filePath.get(), entriesToWrite, Collections.emptyList(), abbreviationRepository);
            writtenToAFile = true;
        }
        return writtenToAFile;
    }

    public boolean exportToFileByPath(BibDatabaseContext databaseContext, FilePreferences filePreferences, Path filePath, JournalAbbreviationRepository abbreviationRepository) throws Exception {
        if (!Files.exists(filePath, new LinkOption[0])) {
            return false;
        }
        boolean writtenABibEntry = false;
        for (BibEntry entry : databaseContext.getEntries()) {
            for (LinkedFile linkedFile : entry.getFiles()) {
                Optional<Path> linkedFilePath;
                if (!linkedFile.getFileType().equals(this.fileType.getName()) || !(linkedFilePath = linkedFile.findIn(databaseContext.getFileDirectories(filePreferences))).isPresent() || !Files.exists(linkedFilePath.get(), new LinkOption[0]) || !Files.isSameFile(linkedFilePath.get(), filePath)) continue;
                this.export(databaseContext, filePath, List.of(entry), Collections.emptyList(), abbreviationRepository);
                writtenABibEntry = true;
            }
        }
        return writtenABibEntry;
    }
}

