/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.paint.Color;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.AllEntriesGroup;
import org.jabref.model.groups.AutomaticGroup;
import org.jabref.model.groups.AutomaticKeywordGroup;
import org.jabref.model.groups.AutomaticPersonsGroup;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.groups.KeywordGroup;
import org.jabref.model.groups.RegexKeywordGroup;
import org.jabref.model.groups.SearchGroup;
import org.jabref.model.groups.TexGroup;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.model.strings.StringUtil;

public class GroupSerializer {
    private static String serializeAllEntriesGroup() {
        return "AllEntriesGroup:";
    }

    private String serializeExplicitGroup(ExplicitGroup group) {
        StringBuilder sb = new StringBuilder();
        sb.append("StaticGroup:");
        sb.append(StringUtil.quote(group.getName(), ";", '\\'));
        sb.append(";");
        sb.append(group.getHierarchicalContext().ordinal());
        sb.append(";");
        this.appendGroupDetails(sb, group);
        return sb.toString();
    }

    private String serializeKeywordGroup(KeywordGroup group) {
        Boolean isRegex = group instanceof RegexKeywordGroup;
        StringBuilder sb = new StringBuilder();
        sb.append("KeywordGroup:");
        sb.append(StringUtil.quote(group.getName(), ";", '\\'));
        sb.append(";");
        sb.append(group.getHierarchicalContext().ordinal());
        sb.append(";");
        sb.append(StringUtil.quote(group.getSearchField().getName(), ";", '\\'));
        sb.append(";");
        sb.append(StringUtil.quote(group.getSearchExpression(), ";", '\\'));
        sb.append(";");
        sb.append(StringUtil.booleanToBinaryString(group.isCaseSensitive()));
        sb.append(";");
        sb.append(StringUtil.booleanToBinaryString(isRegex));
        sb.append(";");
        this.appendGroupDetails(sb, group);
        return sb.toString();
    }

    private String serializeSearchGroup(SearchGroup group) {
        StringBuilder sb = new StringBuilder();
        sb.append("SearchGroup:");
        sb.append(StringUtil.quote(group.getName(), ";", '\\'));
        sb.append(";");
        sb.append(group.getHierarchicalContext().ordinal());
        sb.append(";");
        sb.append(StringUtil.quote(group.getSearchExpression(), ";", '\\'));
        sb.append(";");
        sb.append(StringUtil.booleanToBinaryString(group.getSearchFlags().contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE)));
        sb.append(";");
        sb.append(StringUtil.booleanToBinaryString(group.getSearchFlags().contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION)));
        sb.append(";");
        this.appendGroupDetails(sb, group);
        return sb.toString();
    }

    private void appendGroupDetails(StringBuilder builder, AbstractGroup group) {
        builder.append(StringUtil.booleanToBinaryString(group.isExpanded()));
        builder.append(";");
        builder.append(group.getColor().map(Color::toString).orElse(""));
        builder.append(";");
        builder.append(group.getIconName().orElse(""));
        builder.append(";");
        builder.append(group.getDescription().orElse(""));
        builder.append(";");
    }

    public List<String> serializeTree(GroupTreeNode node) {
        ArrayList<String> representation = new ArrayList<String>();
        representation.add(String.valueOf(node.getLevel()) + " " + this.serializeGroup(node.getGroup()));
        for (GroupTreeNode child : node.getChildren()) {
            representation.addAll(this.serializeTree(child));
        }
        return representation;
    }

    private String serializeGroup(AbstractGroup group) {
        if (group instanceof AllEntriesGroup) {
            return GroupSerializer.serializeAllEntriesGroup();
        }
        if (group instanceof ExplicitGroup) {
            ExplicitGroup explicitGroup = (ExplicitGroup)group;
            return this.serializeExplicitGroup(explicitGroup);
        }
        if (group instanceof KeywordGroup) {
            KeywordGroup keywordGroup = (KeywordGroup)group;
            return this.serializeKeywordGroup(keywordGroup);
        }
        if (group instanceof SearchGroup) {
            SearchGroup searchGroup = (SearchGroup)group;
            return this.serializeSearchGroup(searchGroup);
        }
        if (group instanceof AutomaticKeywordGroup) {
            AutomaticKeywordGroup keywordGroup = (AutomaticKeywordGroup)group;
            return this.serializeAutomaticKeywordGroup(keywordGroup);
        }
        if (group instanceof AutomaticPersonsGroup) {
            AutomaticPersonsGroup personsGroup = (AutomaticPersonsGroup)group;
            return this.serializeAutomaticPersonsGroup(personsGroup);
        }
        if (group instanceof TexGroup) {
            TexGroup texGroup = (TexGroup)group;
            return this.serializeTexGroup(texGroup);
        }
        throw new UnsupportedOperationException("Don't know how to serialize group" + group.getClass().getName());
    }

    private String serializeTexGroup(TexGroup group) {
        StringBuilder sb = new StringBuilder();
        sb.append("TexGroup:");
        sb.append(StringUtil.quote(group.getName(), ";", '\\'));
        sb.append(";");
        sb.append(group.getHierarchicalContext().ordinal());
        sb.append(";");
        sb.append(StringUtil.quote(FileUtil.toPortableString(group.getFilePath()), ";", '\\'));
        sb.append(";");
        this.appendGroupDetails(sb, group);
        return sb.toString();
    }

    private String serializeAutomaticPersonsGroup(AutomaticPersonsGroup group) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutomaticPersonsGroup:");
        this.appendAutomaticGroupDetails(sb, group);
        sb.append(StringUtil.quote(group.getField().getName(), ";", '\\'));
        sb.append(";");
        this.appendGroupDetails(sb, group);
        return sb.toString();
    }

    private void appendAutomaticGroupDetails(StringBuilder builder, AutomaticGroup group) {
        builder.append(StringUtil.quote(group.getName(), ";", '\\'));
        builder.append(";");
        builder.append(group.getHierarchicalContext().ordinal());
        builder.append(";");
    }

    private String serializeAutomaticKeywordGroup(AutomaticKeywordGroup group) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutomaticKeywordGroup:");
        this.appendAutomaticGroupDetails(sb, group);
        sb.append(StringUtil.quote(group.getField().getName(), ";", '\\'));
        sb.append(";");
        sb.append(StringUtil.quote(group.getKeywordDelimiter().toString(), ";", '\\'));
        sb.append(";");
        sb.append(StringUtil.quote(group.getKeywordHierarchicalDelimiter().toString(), ";", '\\'));
        sb.append(";");
        this.appendGroupDetails(sb, group);
        return sb.toString();
    }
}

