/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.l10n.Localization;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RemoveEnclosingBracesFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("Remove enclosing braces", new Object[0]);
    }

    @Override
    public String getKey() {
        return "remove_braces";
    }

    @Override
    public String getDescription() {
        return Localization.lang("Removes braces encapsulating the complete field content.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "{In CDMA}";
    }

    @Override
    public String format(String value) {
        String formatted = value;
        while (formatted.length() >= 2 && formatted.charAt(0) == '{' && formatted.charAt(formatted.length() - 1) == '}') {
            String trimmed = formatted.substring(1, formatted.length() - 1);
            if (this.hasNegativeBraceCount(trimmed)) {
                return formatted;
            }
            formatted = trimmed;
        }
        return formatted;
    }

    private boolean hasNegativeBraceCount(String value) {
        int braceCount = 0;
        for (int index = 0; index < value.length(); ++index) {
            char charAtIndex = value.charAt(index);
            if (charAtIndex == '{') {
                ++braceCount;
            } else if (charAtIndex == '}') {
                --braceCount;
            }
            if (braceCount >= 0) continue;
            return true;
        }
        return false;
    }
}

